/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class FortressConfigHandler {
    public static Configuration config;
    public static String[] fortress_prefix;
    public static String[] fortress_root_initial;
    public static String[] fortress_root_syllables;
    public static String[] fortress_root_terminal;
    public static String[] fortress_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            FortressConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        fortress_prefix = config.getString("Prefixes", "Fortress Syllable Pool", "Nether", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        fortress_root_initial = config.getString("Root: Initial", "Fortress Syllable Pool", "\u00c9, A, A, A, A, A, A, A, Aea, Ca, Cae, Ce, Ce, Cha, Chi, Ci, Co, Di, Di, Dra, Du, E, E, E, Eu, Fey, Ga, Gj\u00f6, Gja, Go, Ha, Ha, He, He, He, Hy, Hy, I, La, Le, Le, M\u00f3, Me, Me, Mi, Mi, Mu, Mu, N\u00e1, Na, Ni, Ni, O, Pa, Pa, Pa, Pe, Pe, Phae, Phle, Plu, Pro, Rha, So, Sty, Ta, Ta, Tha, Ti, Ti, Tu, Xi, Yo, You", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        fortress_root_syllables = config.getString("Root: Syllables", "Fortress Syllable Pool", "a, ba, ba, by, ca, che, chi, chly, cra, cri, ctla, cu, cy, da, de, dhgu, dmu, do, dra, dra, du, f, fl, ga, gae, ge, ku, le, le, li, lj\u00fa, lla, ma, ma, me, mi, na, nd\u00e6, ne, no, ntau, o, o, o, pno, ra, rbe, re, rgo, ri, ri, rka, rm, rna, ro, rphe, rpy, rse, rta, ry, si, si, spe, spho, str\u00f6, ta, the, to, va, yu, bu, ci, cto, da, de, dh, dhni, dne, hei, ka, la, lba, lhe, lhei, lla, lle, lu, ma, mo, mu, ne, no, no, pha, pho, pho, phy, ra, ra, rbr\u00fa, ro, rtha, ru, ru, te, te, tho, to, tu, u, u, u, \u00eb, \u00eb, ba, la, le, mi, mo, ne, ne, ni, nthu, ri, a, a, u", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        fortress_root_terminal = config.getString("Root: Terminal", "Fortress Syllable Pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, g, l, l, l, ll, ll, m, m, m, n, n, n, n, n, n, nd, r, r, r, r, rch, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, ss, t, x", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        fortress_suffix = config.getString("Suffixes", "Fortress Syllable Pool", "Fortress", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("Fortress Syllable Pool", "Syllable Count Weighting", NamePieces.fortress_syllable_count_weights, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "Fortress Syllable Pool", fortress_root_initial.length - 1 <= 0 ? 0.0f : ((float)fortress_prefix.length - 1.0f) / (float)(fortress_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "Fortress Syllable Pool", fortress_root_initial.length - 1 <= 0 ? 0.0f : ((float)fortress_suffix.length - 1.0f) / (float)(fortress_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

