/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class AlienConfigHandler {
    public static Configuration config;
    public static String[] alien_prefix;
    public static String[] alien_root_initial;
    public static String[] alien_root_syllables;
    public static String[] alien_root_terminal;
    public static String[] alien_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            AlienConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        alien_prefix = config.getString("Prefixes", "Alien Syllable Pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        alien_root_initial = config.getString("Root: Initial", "Alien Syllable Pool", "'Y, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ai, Ay, B, Ba, Ba, Ba, Bo, Bu, Bya, C, Chau, Co, Co, Cro, Cthaa, Cthae, Cthu, Cthu, Cthy, Cto, Cxa, Cy, Cy\u00e4, D, Da, Dhu, Di, Dray, Dry, Dy, Dy, Dz\u00e9, E, E, Ei, Ei, Fu, Ge, Gha, Ghi, Ghro, Ghro, Gi, Gla, Glee, Gloo, Go, Go, Go, Go, Go, Gtu, Gu, Gu, Gwa, Gz, H, Ha, Ha, Ha, Ha, Hai, Hna, Hziu, I, I, I, I, I, I, I, Ia, Ja, Je, Ju, K, Ka, Ka, Ka, Kaa, Kaa, Kau, Kha, Klaa, Klo, Klu, Kra, Krai, Kri, Ktha, Ktha, Ku, La, Le, Lloi, Lo, Lo, Lo, Lu, Ly, M, M, M, Ma, Mla, Mno, Mo, Mo, Mo, Mo, Mri, My, N, N, N, Na, Nee, Ngi, Ngy, No, No, Nu, Ny, Ny, Ny, Nya, Nya, Nyo, O, O, O, O, O, O, O, O, Oo, Ou, Pa, Pe, Pha, Pha, Po, Psu, Pta, Q, Qu, Qua, R, R, Ra, Ra, Raa, Rha, Rha, Rho, Ri, Ro, S, Sa, Saa, Sca, Se, Se, Se, Sfa, Sha, Sha, Sha, Sha, Shau, She, Shi, Shli, Sho, Shte, Shu, Shu, Shuy, Stha, Su, Su, Swa, Ta, Te, Th, Tha, Tha, Tha, Tha, Tho, To, Tru, Tsa, Tu, Tu, Tu, U, U, U, U, Ui, V, Ve, Vhu, Vi, Vi, Vo, Vo, Vo, Vu, Wa, X, Xa, Xa, Xe, Xi, Xi, Xi, Xi, Xo, Xo, Y, Y, Y, Y, Y, Y, Ya, Ya, Ya, Ye, Ye, Yha, Yha, Yhou, Yi, Yi, Yi, Yo, Yo, Yo, Yo, Yu, Yu, Yu, Z, Z, Za, Ze, Zha, Zi, Zi, Zo, Zo, Zu, Zvi", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        alien_root_syllables = config.getString("Root: Syllables", "Alien Syllable Pool", "-Ga, -Ho, -Ka, -Kthu, -Ni, -Ra, 'ba, 'chte, 'e, 'gnu, 'go, 'li, 'lla, 'lo, 'na, 'Na, 'ne, 'ry, 'tha, 'to, 'tya, 'y, a, a, a, b-Ni, b-Te, b'mbu, ba, bb-Tst, bbi, bbo, be, bho, bho, bo, bo, bu, c'Naa, cha, chi, ckla, cn\u00e0, cra, cte, ctho, cto, cto, cu, d-Tha, da, dde_M, de, dh-yaa, dhra, dley, dme, e, g-Hoo, g-Ko, g-Sa, g-Si, g-So, g'Na, ga, gg-Ha, gg-Sha, ggdy, ggha, ggy, gha, gho, ghya, gna, gna, gni, gnu, go, go, go, go, gra, gtha, h'i, h'Thu, ha, ho, i, i, jh'Kaa, jha, k-Sha, ki, kla, ko, kra, kru, l_Tho, l-go, l'kru, la, la, lbe, lda, le, le-O, lgna, lhu, li, li, li, li, lko, lla, lo, lpo, lquo, ltha, lthoo, lti, lu, lu, lu, lzscha, m_Cru, ma, ma, mi, mma, mmu, mna, mo, mo, mqua, mu, mu, n-Te, na, nai, nda, nda, nde, nde, ndo, ndy, nee, ni, nlu, no, no, no, npe, ntoo, nu, o, o, o, o, o, pha, phoo, qua, r-A, r-Ko, r'la, ra, ra, ra, ra, rdi, rdne, rg\u00f2, rga, ri, rla, rlo, rmo, ro, ro, ro, rpa, rqu, rr, rra, rri, rry, rse, rte, rtho, rtll, ru, rva, rwa, sa, sai, sba, sei, sgu, sha, shtu, smi, so, sso, ssu, sta, sta, sta, stu, sty, t'U, ta, te, th-Go, th-Ho, th-O, tha, tha, tha, tha, tha, thne, tho, tho, tho, thu, thu, thya, ti, tla, tli, tli, tu, tzi, u, ue, va, vha, w'ke, w\u00e0, xa, xii, xtyo, xu, xu, ya, ya, yi, za, zho, zo, zta, -Ga, -Gha, -Sa, -Thu, -Y, -ya, 'e, 'i, 'ngo, 'so, \u00f1a, a, a, b_G, ch-Na, cll, dda, dda, do, do, do, e, fu, g, ga, ge, ge, gghua, gghua, ggi, ggu, ggua, ggua, ggua, gh-Yai, gha, gha, ghra, gnni, go, go, go, gtha, gtha, ht_Z, i, ii, ka, ka, ki, klu, ko, l_U, l\u00ff, la, la, la, lca, le, lhu, li, li, lka, lla, lla, lla, lls-H, llu, lo, lo, lo, lpha, lu, lu, lu, lyo, lzhe, m_Shai, m-Zha, ma, ma, mbra, mi, mi, mmo, mo, mo, mpha, n-Go, na, na, nai, nche, ndrra, ne, nnga, no, no, nu, o, pha, pi, pse, qua, r, r_Fau, r'i, ra, ra, rg_Ryo, rga, ri, ri, ro, ro, rra, rtha, rthua, ru, sa, sca, sh-Ho, sha, sha, shu, ssa, sui, ta, ta, th-a, th-Ka, th'lu, tha, the, thna, tho, tho, tho, tho, thrha, tii, tli, tse, tu, u, va, ve, wr, xtla, ya, ye, yi, zo, _Gwa, -B, -Tha, 'u, a, a, a, ba, bhy, cha, cu, d_E, de, g'Na, ga, ggua, gly, gm, go, hn, ka, ko, ku, la, lo, mghi, n'tho, na, ni, nsha, o, o, o, pa, r'He, ra, ra, rgo, rlo, sss, sua, te, th\u00e6, thi, thla, ttau, -se, 'n, a, e, gni, lle, n\u00ef, ndu, nzha, qqa, -Mo, \u00e9, rr'ro, l\u00fb", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        alien_root_terminal = config.getString("Root: Terminal", "Alien Syllable Pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, 'st, b, b, bb, c, c, c, ch, ch, ck, ct, d, d, d, g, g, g, g, g, g, g, g, g, g, g, g, g, g, g, g, gh, gh, gn, h, h, h, h, h, h, hl, k, k, k, k, k, k, k, l, l, l, l, l, l, l, l, lbh, ll, ll, m, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, ng, ng, njh, nn, ns, p, p, ps, q, r, r, r, r, r, r, r, r, r, r, r, r, rhn, rn, rt, rth, rth, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, sh, sh, sh, sh, ss, ss, st, t, t, t, t, t, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, th, x, x, z, z, z", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        alien_suffix = config.getString("Suffixes", "Alien Syllable Pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("Alien Syllable Pool", "Syllable Count Weighting", NamePiecesEntities.alien_syllable_count_weights, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "Alien Syllable Pool", alien_root_initial.length - 1 <= 0 ? 0.0f : ((float)alien_prefix.length - 1.0f) / (float)(alien_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "Alien Syllable Pool", alien_root_initial.length <= 0 ? 0.0f : ((float)alien_suffix.length - 1.0f) / (float)(alien_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

