/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism_integrations.IModCompat;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class ModCompatLoader
implements IInitListener {
    private static final String TAG = "ModCompat";
    private final String configName;
    @Nullable
    private List<IModCompat> availableModCompats = new LinkedList<IModCompat>();
    private List<IModCompat> loadedModCompats;
    private List<IModCompat> incompatibleCompats = new LinkedList<IModCompat>();
    @Nullable
    private Configuration config;

    public ModCompatLoader(String configName) {
        this.configName = configName;
    }

    public void addModCompat(IModCompat compat) {
        if (this.availableModCompats == null) {
            throw new IllegalStateException("Add mod compats BEFORE pre-init (" + compat.getModID() + ")");
        }
        this.availableModCompats.add(compat);
    }

    public List<IModCompat> getAvailableModCompats() {
        return this.availableModCompats;
    }

    @Nullable
    public Configuration getConfig() {
        return this.config;
    }

    public List<IModCompat> getIncompatibleCompats() {
        return ImmutableList.copyOf(this.incompatibleCompats);
    }

    public List<IModCompat> getLoadedModCompats() {
        return ImmutableList.copyOf(this.loadedModCompats);
    }

    public void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        if (step == IInitListener.Step.PRE_INIT) {
            this.prepareModCompats(((FMLPreInitializationEvent)event).getModConfigurationDirectory());
        }
        Iterator<IModCompat> it = this.loadedModCompats.iterator();
        while (it.hasNext()) {
            IModCompat next = it.next();
            try {
                next.onInitStep(step, event);
            }
            catch (Exception e) {
                VampLib.log.e(TAG, "---------------------------------------------------------", new Object[0]);
                VampLib.log.e(TAG, (Throwable)e, "Mod Compat %s threw an exception during %s. Unloading.", new Object[]{next.getModID(), step});
                VampLib.log.e(TAG, "---------------------------------------------------------", new Object[0]);
                it.remove();
            }
        }
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return Loader.isModLoaded((String)modCompat.getModID());
    }

    private boolean isVersionOk(IModCompat modCompat) {
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modCompat.getModID());
        if (mod != null) {
            String s = modCompat.getAcceptedVersionRange();
            if (s == null) {
                return true;
            }
            VersionRange range = null;
            try {
                range = VersionRange.createFromVersionSpec((String)s);
            }
            catch (InvalidVersionSpecificationException e) {
                VampLib.log.e(TAG, "Invalid version spec %s for %s", new Object[]{s, modCompat.getModID()});
                return false;
            }
            return range.containsVersion(mod.getProcessedVersion());
        }
        return false;
    }

    private void prepareModCompats(File configDir) {
        if (this.availableModCompats == null) {
            VampLib.log.w(TAG, "Trying to load mod compat twice", new Object[0]);
            return;
        }
        this.config = new Configuration(new File(configDir, this.configName));
        LinkedList<IModCompat> loaded = new LinkedList<IModCompat>();
        for (IModCompat modCompat : this.availableModCompats) {
            if (!this.isModLoaded(modCompat)) continue;
            ConfigCategory compatCat = this.config.getCategory(modCompat.getModID());
            compatCat.setComment("Configure mod compatibility between Vampirism and " + modCompat.getModID());
            if (!this.config.getBoolean("enable_compat_" + modCompat.getModID(), compatCat.getName(), true, "If the compatibility for this mod should be loaded")) continue;
            if (this.isVersionOk(modCompat)) {
                modCompat.loadConfigs(this.config, compatCat);
                loaded.add(modCompat);
                VampLib.log.d(TAG, "Prepared %s compatibility", new Object[]{modCompat.getModID()});
                continue;
            }
            VampLib.log.w(TAG, "Cannot load %s compat due to incompatible version", new Object[]{modCompat.getModID()});
            this.incompatibleCompats.add(modCompat);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
        this.loadedModCompats = loaded;
        this.availableModCompats = null;
    }
}

