/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.ItemSimpleCrossbow;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTechCrossbow
extends ItemSimpleCrossbow {
    public static final int MAX_ARROW_COUNT = 12;

    private static int getArrowsLeft(@Nonnull ItemStack bowStack) {
        NBTTagCompound nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return 0;
        }
        return nbt.func_74762_e("arrows");
    }

    private static ItemStack setArrowsLeft(@Nonnull ItemStack bowStack, int arrows) {
        int i = Math.max(-1, Math.min(12, arrows));
        NBTTagCompound nbt = bowStack.func_77942_o() ? bowStack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("arrows", i);
        bowStack.func_77982_d(nbt);
        return bowStack;
    }

    private static boolean reduceArrowCount(@Nonnull ItemStack bowStack, Random rnd) {
        NBTTagCompound nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return false;
        }
        int count = nbt.func_74762_e("arrows");
        if (count == -1) {
            return true;
        }
        if (count == 0) {
            return false;
        }
        int frugal = ItemTechCrossbow.isCrossbowFrugal(bowStack);
        if (frugal > 0 && rnd.nextInt(Math.max(2, 4 - frugal)) == 0) {
            return true;
        }
        nbt.func_74768_a("arrows", count - 1);
        bowStack.func_77982_d(nbt);
        return true;
    }

    public static ItemStack getLoadedItemStack(ItemTechCrossbow crossbow) {
        return ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)crossbow, 1), 12);
    }

    public static ItemStack getUnLoadedItemStack(ItemTechCrossbow crossbow) {
        return ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)crossbow, 1), 0);
    }

    public ItemTechCrossbow(String regName, float speed, int cooldown, int maxDamage) {
        super(regName, speed, cooldown, maxDamage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int arrows = ItemTechCrossbow.getArrowsLeft(stack);
        if (arrows == -1) {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translate(Enchantments.field_185312_x.func_77320_a()));
        } else if (arrows == 0) {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translate("text.vampirism.crossbow.not_loaded"));
        } else {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translateFormatted("text.vampirism.crossbow.loaded_arrow_count", arrows));
        }
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        return HunterSkills.tech_weapons;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)this), 0));
            items.add((Object)ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)this), 12));
        }
    }

    @Override
    @Nonnull
    protected ItemStack findAmmo(EntityPlayer player, ItemStack bowStack) {
        boolean arrow = ItemTechCrossbow.reduceArrowCount(bowStack, player.func_70681_au());
        if (!arrow) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack.func_190926_b() || !this.isArrowPackage(itemstack)) continue;
                ItemTechCrossbow.setArrowsLeft(bowStack, 12);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(i, 1);
                }
                player.func_184811_cZ().func_185145_a(bowStack.func_77973_b(), this.getReloadCooldown(player, bowStack));
            }
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ModItems.crossbow_arrow);
    }

    @Override
    protected float getArrowVelocity() {
        return 1.7f;
    }

    @Override
    protected int getCooldown(EntityPlayer player, ItemStack stack) {
        return 2;
    }

    @Override
    protected boolean isCrossbowInfinite(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean shouldConsumeArrow(Random rnd, ItemStack arrowStack, boolean playerCreative, boolean bowInfinite, int frugal) {
        return false;
    }

    private int getReloadCooldown(EntityPlayer player, ItemStack bowStack) {
        return 100;
    }

    private boolean isArrowPackage(@Nonnull ItemStack stack) {
        return ((Object)((Object)ModItems.tech_crossbow_ammo_package)).equals(stack.func_77973_b());
    }
}

