/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.IItemWithTierNBTImpl;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHunterCoat
extends VampirismHunterArmor
implements IItemWithTierNBTImpl {
    private static final String baseRegName = "hunter_coat";
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{3, 7, 9, 3};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{3, 6, 8, 3};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{2, 5, 6, 2};

    public static boolean isFullyEquipped(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemHunterCoat) continue;
            return false;
        }
        return true;
    }

    public ItemHunterCoat(EntityEquipmentSlot equipmentSlotIn) {
        super(ItemArmor.ArmorMaterial.IRON, equipmentSlotIn, baseRegName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(stack, tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        switch (this.getTier(stack)) {
            case ENHANCED: {
                return this.getTextureLocation("hunter_coat_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("hunter_coat_ultimate", slot, type);
            }
        }
        return this.getTextureLocation(baseRegName, slot, type);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getTier(stack);
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }
}

