/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.inventory.SimpleInventory;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class HunterTrainerContainer
extends InventoryContainer {
    private static final Item[] items = new Item[]{Items.field_151042_j, Items.field_151043_k, ModItems.hunter_intel};
    private final EntityPlayer player;
    private boolean changed = false;
    private ItemStack missing = ItemStack.field_190927_a;

    public HunterTrainerContainer(EntityPlayer player) {
        super(player.field_71071_by, new HunterTrainerInventory());
        ((HunterTrainerInventory)this.tile).setChangeListener(this);
        this.player = player;
        this.onInventoryChanged();
    }

    public boolean canLevelup() {
        int targetLevel = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION) + 1;
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        if (!levelingConf.isLevelValidForTrainer(targetLevel)) {
            return false;
        }
        int[] req = levelingConf.getItemRequirementsForTrainer(targetLevel);
        this.missing = InventoryHelper.checkItems(this.tile, items, new int[]{req[0], req[1], 1}, new int[]{Short.MAX_VALUE, Short.MAX_VALUE, levelingConf.getHunterIntelMetaForLevel(targetLevel) == 0 ? Short.MAX_VALUE : -levelingConf.getHunterIntelMetaForLevel(targetLevel)});
        return this.missing.func_190926_b();
    }

    public HunterTrainerInventory getHunterTrainerInventory() {
        return (HunterTrainerInventory)this.tile;
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            for (int i = 0; i < this.tile.func_70302_i_(); ++i) {
                ItemStack itemstack = this.tile.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                playerIn.func_71019_a(itemstack, false);
            }
        }
    }

    @Override
    public void onInventoryChanged() {
        this.changed = true;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            int old = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION);
            FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, old + 1);
            int[] req = HunterLevelingConf.instance().getItemRequirementsForTrainer(old + 1);
            InventoryHelper.removeItems(this.tile, new int[]{req[0], req[1], 1});
            this.player.func_70690_d(new PotionEffect(ModPotions.saturation, 400, 2));
        }
    }

    public static class HunterTrainerInventory
    extends SimpleInventory {
        public HunterTrainerInventory() {
            super(new InventorySlot[]{new InventorySlot(Items.field_151042_j, 27, 26), new InventorySlot(Items.field_151043_k, 57, 26), new InventorySlot(ModItems.hunter_intel, 86, 26)});
        }

        public String func_70005_c_() {
            return "entity.vampirism.hunter_trainer.name";
        }

        @Override
        public boolean func_191420_l() {
            return false;
        }
    }
}

