/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.inventory.SimpleInventory;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class HunterBasicContainer
extends InventoryContainer {
    private final IHunterPlayer player;

    public HunterBasicContainer(InventoryPlayer invPlayer) {
        super(invPlayer, new HunterBasicInventory());
        this.player = HunterPlayer.get(invPlayer.field_70458_d);
    }

    public boolean canLevelUp() {
        return this.getMissingCount() == 0;
    }

    public int getMissingCount() {
        int targetLevel = this.player.getLevel() + 1;
        ItemStack blood = this.tile.func_70301_a(0);
        HunterLevelingConf conf = HunterLevelingConf.instance();
        if (!conf.isLevelValidForBasicHunter(targetLevel)) {
            return -1;
        }
        int required = conf.getVampireBloodCountForBasicHunter(targetLevel);
        return blood.func_190926_b() || !blood.func_77973_b().equals((Object)ModItems.vampire_blood_bottle) ? required : Math.max(0, required - blood.func_190916_E());
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            for (int i = 0; i < this.tile.func_70302_i_(); ++i) {
                ItemStack itemstack = this.tile.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                playerIn.func_71019_a(itemstack, false);
            }
        }
    }

    public void onLevelUpClicked() {
        if (!this.canLevelUp()) {
            return;
        }
        int target = this.player.getLevel() + 1;
        this.tile.func_70298_a(0, HunterLevelingConf.instance().getVampireBloodCountForBasicHunter(target));
        FactionPlayerHandler.get(this.player.getRepresentingPlayer()).setFactionLevel(VReference.HUNTER_FACTION, target);
        this.player.getRepresentingPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.basic_hunter.levelup", new Object[0]));
        this.player.getRepresentingPlayer().func_71053_j();
    }

    private static class HunterBasicInventory
    extends SimpleInventory {
        public HunterBasicInventory() {
            super(new InventorySlot[]{new InventorySlot(ModItems.vampire_blood_bottle, 27, 32)});
        }

        public String func_70005_c_() {
            return "entity.vampirism.vampire_hunter.name";
        }
    }
}

