/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.minions.IMinion;
import de.teamlapen.vampirism.api.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.api.entity.minions.ISaveableMinion;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMinion;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.minions.ai.MinionAIHurtByTarget;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBaron;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.util.MinionHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityVampireMinionBase
extends EntityVampireBase
implements IVampireMinion {
    private static final DataParameter<Integer> TEXTURE = EntityDataManager.func_187226_a(EntityVampireMinionBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private IMinionCommand activeCommand = this.createDefaultCommand();
    private boolean wantsBlood = false;

    public EntityVampireMinionBase(World world) {
        super(world, false);
        this.activeCommand.onActivated();
    }

    @Override
    public void activateMinionCommand(IMinionCommand command) {
        if (command == null) {
            return;
        }
        this.activeCommand.onDeactivated();
        this.activeCommand = command;
        this.activeCommand.onActivated();
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return super.func_70686_a(p_70686_1_);
    }

    public IMinionCommand getActiveCommand() {
        return this.activeCommand;
    }

    public float func_180484_a(BlockPos pos) {
        float i = 0.5f - this.field_70170_p.func_175724_o(pos);
        if (i > 0.0f) {
            return i;
        }
        return 0.01f;
    }

    public int getOldVampireTexture() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE);
    }

    public void setOldVampireTexture(int oldVampireTexture) {
        this.func_184212_Q().func_187227_b(TEXTURE, (Object)oldVampireTexture);
    }

    public int func_70627_aG() {
        return 2000;
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return !forSpawnCount && super.isCreatureType(type, forSpawnCount);
    }

    public void func_70074_a(EntityLivingBase entity) {
        if (this.getLord() != null && this.getLord() instanceof EntityVampireBaron) {
            ((EntityVampireBaron)this.getLord()).func_70074_a(entity);
        } else {
            super.func_70074_a(entity);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.getOldVampireTexture() != -1 && this.field_70173_aa > 50) {
            this.setOldVampireTexture(-1);
        }
        if (this.getOldVampireTexture() != -1 && this.field_70170_p.field_72995_K) {
            UtilLib.spawnParticlesAroundEntity((EntityLivingBase)this, EnumParticleTypes.SPELL_WITCH, 1.0, 3);
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70729_aU) {
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
            for (EntityItem entityitem : list) {
                ItemStack itemstack;
                if (entityitem.field_70128_L || entityitem.func_92059_d().func_190926_b() || !this.activeCommand.shouldPickupItem(itemstack = entityitem.func_92059_d())) continue;
                ItemStack stack1 = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
                if (!stack1.func_190926_b()) {
                    this.func_70099_a(stack1, 0.0f);
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                entityitem.func_70106_y();
            }
        }
        if (Balance.mobProps.VAMPIRE_MINION_REGENERATE_SECS >= 0 && this.field_70173_aa % (Balance.mobProps.VAMPIRE_MINION_REGENERATE_SECS * 20) == 0 && (this.func_142013_aG() == 0 || this.func_142013_aG() - this.field_70173_aa > 100)) {
            this.func_70691_i(2.0f);
        }
        super.func_70636_d();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        IMinionCommand command = this.getCommand(nbt.func_74762_e("command_id"));
        if (command != null) {
            this.activateMinionCommand(command);
        }
        if (nbt.func_150297_b("CustomName", 8) && nbt.func_74779_i("CustomName").length() > 0) {
            this.tryToSetName(nbt.func_74779_i("CustomName"), null);
        }
    }

    public void func_96094_a(String s) {
    }

    public void setWantsBlood(boolean wantsBlood) {
        this.wantsBlood = wantsBlood;
    }

    public boolean tryToSetName(String name, @Nullable EntityPlayer player) {
        if (player == null || MinionHelper.isLordSafe((IMinion)this, (Entity)player)) {
            super.func_96094_a(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean wantsBlood() {
        return this.wantsBlood;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("command_id", this.getActiveCommand().getId());
    }

    public boolean func_70039_c(NBTTagCompound nbt) {
        if (this instanceof ISaveableMinion) {
            return false;
        }
        return super.func_70039_c(nbt);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.VAMPIRE_MINION_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.VAMPIRE_MINION_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.VAMPIRE_MINION_MOVEMENT_SPEED);
    }

    protected void copyDataFromMinion(EntityVampireMinionBase from) {
        this.setOldVampireTexture(from.getOldVampireTexture());
        this.setLord(from.getLord());
        this.activateMinionCommand(from.getActiveCommand());
    }

    @Nonnull
    protected abstract IMinionCommand createDefaultCommand();

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)-1);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(8, (EntityAIBase)new MinionAIHurtByTarget(this, false));
    }
}

