/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityCrossbowArrow
extends EntityArrow
implements IEntityCrossbowArrow {
    @Nonnull
    private ItemStack arrowStack = new ItemStack((Item)ModItems.crossbow_arrow);
    private boolean ignoreHurtTimer = false;

    public static EntityCrossbowArrow createWithShooter(World world, EntityLivingBase shooter, double heightOffset, double centerOffset, boolean rightHanded, ItemStack arrow) {
        double yaw = (double)((shooter.field_70177_z - 90.0f) / 180.0f) * Math.PI;
        if (rightHanded) {
            yaw += Math.PI;
        }
        double posX = shooter.field_70165_t - Math.sin(yaw) * centerOffset;
        double posZ = shooter.field_70161_v + Math.cos(yaw) * centerOffset;
        EntityCrossbowArrow entityArrow = new EntityCrossbowArrow(world, posX, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f + heightOffset, posZ, arrow);
        entityArrow.field_70250_c = shooter;
        if (shooter instanceof EntityPlayer) {
            entityArrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
        return entityArrow;
    }

    public EntityCrossbowArrow(World world) {
        super(world);
    }

    public EntityCrossbowArrow(World worldIn, double x, double y, double z, ItemStack arrow) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.arrowStack = arrow.func_77946_l();
        this.arrowStack.func_190920_e(1);
    }

    public Random getRNG() {
        return this.field_70146_Z;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.arrowStack.deserializeNBT(compound.func_74775_l("arrowStack"));
    }

    @Override
    public void setIgnoreHurtTimer() {
        this.ignoreHurtTimer = true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("arrowStack", (NBTBase)this.arrowStack.func_77955_b(new NBTTagCompound()));
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        Item item = this.arrowStack.func_77973_b();
        if (item instanceof IVampirismCrossbowArrow) {
            if (this.ignoreHurtTimer && living.field_70172_ad > 0) {
                living.field_70172_ad = 0;
            }
            ((IVampirismCrossbowArrow)item).onHitEntity(this.arrowStack, living, this, (Entity)(this.field_70250_c == null ? this : this.field_70250_c));
        }
    }

    protected ItemStack func_184550_j() {
        return this.arrowStack;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Item item;
        if (raytraceResultIn.field_72308_g == null && (item = this.arrowStack.func_77973_b()) instanceof IVampirismCrossbowArrow) {
            ((IVampirismCrossbowArrow)item).onHitBlock(this.arrowStack, raytraceResultIn.func_178782_a(), this, (Entity)(this.field_70250_c == null ? this : this.field_70250_c));
        }
        super.func_184549_a(raytraceResultIn);
    }
}

