/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.Logger;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.BloodGrinderValueLoader;
import de.teamlapen.vampirism.config.BloodValueLoader;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModEventHandler;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.core.TestCommand;
import de.teamlapen.vampirism.core.VampirismCommand;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.VampirismEntitySelectors;
import de.teamlapen.vampirism.entity.action.EntityActionManager;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.modcompat.SpongeModCompat;
import de.teamlapen.vampirism.modcompat.guide.GuideAPICompat;
import de.teamlapen.vampirism.modcompat.jei.JEIModCompat;
import de.teamlapen.vampirism.network.ModGuiHandler;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.player.actions.ActionManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.skills.SkillManager;
import de.teamlapen.vampirism.player.vampire.BloodVision;
import de.teamlapen.vampirism.player.vampire.NightVision;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.potion.blood.BloodPotionRegistry;
import de.teamlapen.vampirism.potion.blood.BloodPotions;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.tileentity.TileTent;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.HalloweenSpecial;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.world.GarlicChunkHandler;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import de.teamlapen.vampirism.world.gen.structure.StructureManager;
import de.teamlapen.vampirism.world.loot.LootHandler;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import java.awt.Color;
import java.io.File;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="vampirism", name="Vampirism", version="1.6.2", acceptedMinecraftVersions="[1.12,)", dependencies="required-after:forge@[14.23.1.2554,);after:guideapi", guiFactory="de.teamlapen.vampirism.client.core.ModGuiFactory", updateJSON="https://maxanier.de/projects/vampirism/versions.json")
public class VampirismMod {
    public static final Logger log = new Logger("vampirism", "de.teamlapen.vampirism");
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final CreativeTabs creativeTab = new CreativeTabs("vampirism"){

        public ItemStack func_78016_d() {
            return new ItemStack((Item)ModItems.vampire_fang);
        }
    };
    private static final EnumCreatureType HUNTER_CREATURE_TYPE = EnumHelper.addCreatureType((String)"VAMPIRISM_HUNTER", IHunterMob.class, (int)25, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
    private static final EnumCreatureType VAMPIRE_CREATURE_TYPE = EnumHelper.addCreatureType((String)"VAMPIRISM_VAMPIRE", IVampireMob.class, (int)30, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
    private static final EnumCreatureAttribute VAMPIRE_CREATURE_ATTRIBUTE = EnumHelper.addCreatureAttribute((String)"VAMPIRISM_VAMPIRE");
    private static final ItemArmor.ArmorMaterial OBSIDIAN_ARMOR_MATERIAL = EnumHelper.addArmorMaterial((String)"obsidian", (String)"diamond", (int)37, (int[])new int[]{3, 7, 9, 3}, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
    @Mod.Instance(value="vampirism")
    public static VampirismMod instance;
    @SidedProxy(clientSide="de.teamlapen.vampirism.proxy.ClientProxy", serverSide="de.teamlapen.vampirism.proxy.ServerProxy")
    public static IProxy proxy;
    public static boolean inDev;
    public final ModCompatLoader modCompatLoader = new ModCompatLoader("vampirism/vampirism_mod_compat.cfg");
    private final RegistryManager registryManager;
    private VersionChecker.VersionInfo versionInfo;

    public static boolean isRealism() {
        return Configs.realism_mode;
    }

    public VampirismMod() {
        this.addModCompats();
        this.registryManager = new RegistryManager();
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        this.setupAPI1();
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String currentVersion;
        this.finishAPI1();
        String string = currentVersion = "@VERSION@".equals("1.6.2") ? "0.0.0-test" : "1.6.2";
        this.versionInfo = Configs.disable_versionCheck ? new VersionChecker.VersionInfo(currentVersion) : VersionChecker.executeVersionCheck("https://maxanier.de/projects/vampirism/versions.php", currentVersion, !inDev && !Configs.disable_collectVersionStat);
        ModEventHandler eventHandler = new ModEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)LootHandler.getInstance());
        GameRegistry.registerWorldGenerator((IWorldGenerator)VampirismWorldGen.getInstance(), (int)1000);
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
        SupporterManager.getInstance().initAsync();
        VampireBookManager.getInstance().init();
        BloodPotions.register();
        StructureManager.init();
        Permissions.init();
        VampirismEntitySelectors.registerSelectors();
        this.registryManager.onInitStep(IInitListener.Step.INIT, (FMLStateEvent)event);
        proxy.onInitStep(IInitListener.Step.INIT, (FMLStateEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.INIT, (FMLStateEvent)event);
        if (HalloweenSpecial.shouldEnable()) {
            HalloweenSpecial.enable();
            MinecraftForge.EVENT_BUS.register((Object)new HalloweenSpecial());
        }
    }

    @Mod.EventHandler
    public void interModComm(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleInterModMessage((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new VampirismCommand());
        event.registerServerCommand((ICommand)new TestCommand());
        VampirismEntityRegistry.getBiteableEntryManager().initDynamic();
        BloodValueLoader.onServerStarting(event.getServer());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        if (!LootHandler.getInstance().checkAndResetInsertedAll()) {
            log.w("LootTables", "-------------------------------", new Object[0]);
            log.w("LootTables", "Failed to inject all loottables", new Object[0]);
            log.w("LootTables", "-------------------------------", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        BloodValueLoader.onServerStopping();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.finishAPI2();
        this.registryManager.onInitStep(IInitListener.Step.POST_INIT, (FMLStateEvent)event);
        proxy.onInitStep(IInitListener.Step.POST_INIT, (FMLStateEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.POST_INIT, (FMLStateEvent)event);
        if (inDev) {
            Tests.runBackgroundTests();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.checkDevEnv();
        HunterPlayer.registerCapability();
        VampirePlayer.registerCapability();
        FactionPlayerHandler.registerCapability();
        ExtendedCreature.registerCapability();
        VampirismVillage.registerCapability();
        this.setupAPI2();
        Configs.init(new File(event.getModConfigurationDirectory(), "vampirism"), inDev);
        Balance.init(new File(event.getModConfigurationDirectory(), "vampirism"), inDev);
        BloodValueLoader.init(new File(event.getModConfigurationDirectory(), "vampirism"));
        BloodGrinderValueLoader.init(new File(event.getModConfigurationDirectory(), "vampirism"));
        this.modCompatLoader.onInitStep(IInitListener.Step.PRE_INIT, (FMLStateEvent)event);
        this.setupAPI3();
        ModFixs fixer = FMLCommonHandler.instance().getDataFixer().init("vampirism", 5);
        fixer.registerFix((IFixType)FixTypes.ENTITY, ModEntities.getEntityIDFixer());
        fixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, ModBlocks.getTileEntityIDFixer());
        fixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, TileTent.getTentFixer());
        fixer.registerFix((IFixType)FixTypes.ENTITY, ModEntities.getEntityCapabilityFixer());
        fixer.registerFix((IFixType)FixTypes.PLAYER, ModEntities.getPlayerCapabilityFixer());
        dispatcher.registerPackets();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new ModGuiHandler());
        this.registryManager.onInitStep(IInitListener.Step.PRE_INIT, (FMLStateEvent)event);
        proxy.onInitStep(IInitListener.Step.PRE_INIT, (FMLStateEvent)event);
        ScoreboardUtil.init();
    }

    private void addModCompats() {
        this.modCompatLoader.addModCompat(new JEIModCompat());
        this.modCompatLoader.addModCompat(new SpongeModCompat());
        this.modCompatLoader.addModCompat(new GuideAPICompat());
    }

    private void checkDevEnv() {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            inDev = true;
            log.setDebug(true);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                log.displayModID();
            }
        }
    }

    private void finishAPI1() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
        ((SkillManager)VampirismAPI.skillManager()).buildSkillTrees();
    }

    private void finishAPI2() {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).finishRegistration();
    }

    private void setupAPI1() {
        FactionRegistry factionRegistry = new FactionRegistry();
        SundamageRegistry sundamageRegistry = new SundamageRegistry();
        VampirismEntityRegistry biteableRegistry = new VampirismEntityRegistry();
        ActionManager actionManager = new ActionManager();
        SkillManager skillManager = new SkillManager();
        GeneralRegistryImpl generalRegistry = new GeneralRegistryImpl();
        EntityActionManager entityActionManager = new EntityActionManager();
        biteableRegistry.setDefaultConvertingHandlerCreator(DefaultConvertingHandler::new);
        BloodPotionRegistry bloodPotionRegistry = new BloodPotionRegistry();
        VampirismAPI.setUpRegistries(factionRegistry, sundamageRegistry, biteableRegistry, actionManager, skillManager, generalRegistry, bloodPotionRegistry, entityActionManager);
        VampirismAPI.setUpAccessors(HunterWeaponCraftingManager.getInstance(), new GarlicChunkHandler.Provider(), AlchemicalCauldronCraftingManager.getInstance());
    }

    private void setupAPI2() {
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().registerPlayableFaction("Vampire", IVampirePlayer.class, -8909405, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.CAP, 15);
        VReference.VAMPIRE_FACTION.setChatColor(TextFormatting.DARK_PURPLE).setUnlocalizedName("text.vampirism.vampire", "text.vampirism.vampires");
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().registerPlayableFaction("Hunter", IHunterPlayer.class, Color.BLUE.getRGB(), REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.CAP, 15);
        VReference.HUNTER_FACTION.setChatColor(TextFormatting.DARK_BLUE).setUnlocalizedName("text.vampirism.hunter", "text.vampirism.hunters");
        VReference.HUNTER_CREATURE_TYPE = HUNTER_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_TYPE = VAMPIRE_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_ATTRIBUTE = VAMPIRE_CREATURE_ATTRIBUTE;
        VReference.OBSIDIAN_ARMOR_MATERIAL = OBSIDIAN_ARMOR_MATERIAL;
    }

    private void setupAPI3() {
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision("nightVision", new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision("bloodVision", new BloodVision());
    }

    static {
        inDev = false;
    }
}

