/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.client.Client;
import ht.treechop.common.network.ConfirmedSetting;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerConfirmSettingsPacket
implements IMessage {
    private List<ConfirmedSetting> settings;

    public ServerConfirmSettingsPacket() {
    }

    public ServerConfirmSettingsPacket(List<ConfirmedSetting> settings) {
        this.settings = settings;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.settings.size());
        this.settings.forEach(setting -> ConfirmedSetting.encode(buffer, setting));
    }

    public void fromBytes(ByteBuf buffer) {
        int numSettings = buffer.readInt();
        this.settings = IntStream.range(0, numSettings).mapToObj($ -> ConfirmedSetting.decode(buffer)).collect(Collectors.toList());
    }

    private static void processSingleSetting(ConfirmedSetting setting) {
        Client.getChopSettings().accept(setting.getField(), setting.getValue());
        setting.event.run(setting);
    }

    public static class Handler
    implements IMessageHandler<ServerConfirmSettingsPacket, IMessage> {
        public IMessage onMessage(ServerConfirmSettingsPacket message, MessageContext context) {
            FMLCommonHandler.instance().getWorldThread(context.netHandler).func_152344_a(() -> message.settings.forEach(x$0 -> ServerConfirmSettingsPacket.processSingleSetting(x$0)));
            return null;
        }
    }
}

