/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface IGuiEventListener {
    default public List<? extends IGuiEventListener> getEventListeners() {
        return Collections.emptyList();
    }

    public boolean isMouseOver(int var1, int var2);

    default public void onClick(int mouseX, int mouseY, int button) {
        Optional<IGuiEventListener> clickedListener = this.getEventListenerForPos(mouseX, mouseY);
        clickedListener.ifPresent(listener -> listener.onClick(mouseX, mouseY, button));
    }

    default public Optional<IGuiEventListener> getEventListenerForPos(int mouseX, int mouseY) {
        for (IGuiEventListener iGuiEventListener : this.getEventListeners()) {
            if (!iGuiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(iGuiEventListener);
        }
        return Optional.empty();
    }
}

