/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.world.gen.structure;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.someguyssoftware.gottschcore.meta.IMetaArchetype;
import com.someguyssoftware.gottschcore.meta.IMetaType;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplate;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplateManager;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.registry.TreasureMetaRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class TreasureTemplateManager
extends GottschTemplateManager {
    private final Map<ResourceLocation, TemplateHolder> templatesByResourceLocation = new HashMap<ResourceLocation, TemplateHolder>();
    private final Table<IMetaArchetype, IMetaType, List<TemplateHolder>> templatesByArchetypeType = HashBasedTable.create();
    private final Table<String, Integer, List<TemplateHolder>> templatesByArchetypeTypeBiome = HashBasedTable.create();
    private static List<String> FOLDER_LOCATIONS = ImmutableList.of((Object)"surface", (Object)"subterranean", (Object)"submerged", (Object)"float", (Object)"wells");
    private Map<StructureMarkers, Block> waterMarkerMap;
    private File worldSaveFolder;

    public TreasureTemplateManager(IMod mod, String resourceFolder, DataFixer fixer) {
        super(mod, resourceFolder, fixer);
        Treasure.LOGGER.debug("creating a TreasureTemplateManager");
        this.waterMarkerMap = Maps.newHashMap((Map)this.getMarkerMap());
        this.waterMarkerMap.put(StructureMarkers.NULL, Blocks.field_150350_a);
        for (StructureArchetype archetype : StructureArchetype.values()) {
            for (StructureType type : StructureType.values()) {
                this.templatesByArchetypeType.put((Object)archetype, (Object)type, new ArrayList(5));
            }
        }
    }

    public void clear() {
        this.templatesByArchetypeTypeBiome.clear();
        this.templatesByArchetypeType.clear();
    }

    public void register(String modID, List<String> resourcePaths) {
        Treasure.LOGGER.debug("registering template resources");
        this.createTemplateFolder(modID);
        Treasure.LOGGER.debug("created templates folder");
        List<ResourceLocation> resourceLocations = this.getResourceLocations(modID, resourcePaths);
        Treasure.LOGGER.debug("acquired template resource locations -> {}", resourceLocations);
        resourceLocations.forEach(loc -> {
            Treasure.LOGGER.debug("loading template resource loc -> {}", (Object)loc.toString());
            this.tableTemplate(modID, (ResourceLocation)loc, this.load((ResourceLocation)loc, this.getMarkerScanList(), this.getReplacementMap()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readTemplate(ResourceLocation location, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        boolean bl;
        Treasure.LOGGER.debug("template path -> {}", (Object)location);
        Path path = Paths.get("structures", this.getMod().getId(), location.func_110623_a());
        File file1 = path.toFile();
        Treasure.LOGGER.debug("template file path -> {}", (Object)file1.getAbsoluteFile());
        if (!file1.exists()) {
            Treasure.LOGGER.debug("file does not exist, read from jar -> {}", (Object)file1.getAbsolutePath());
            return this.readTemplateFromJar(location, markerBlocks, replacementBlocks);
        }
        Treasure.LOGGER.debug("reading template from file system using file path -> {}", (Object)file1.getAbsolutePath());
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            this.readTemplateFromStream(location.toString(), inputstream, markerBlocks, replacementBlocks);
            bl = true;
        }
        catch (Throwable var10) {
            boolean flag;
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readTemplateFromJar(ResourceLocation id, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        boolean bl;
        String s = id.func_110624_b();
        String s1 = id.func_110623_a();
        InputStream inputstream = null;
        try {
            Treasure.LOGGER.debug("attempting to open resource stream -> {}", (Object)id);
            String relativePath = "structures/" + id.func_110624_b() + "/" + id.func_110623_a();
            Treasure.LOGGER.debug("Attempting to load template {} from jar -> {}", (Object)id, (Object)relativePath);
            inputstream = ((Object)((Object)Treasure.instance)).getClass().getClassLoader().getResourceAsStream(relativePath);
            this.readTemplateFromStream(id.toString(), inputstream, markerBlocks, replacementBlocks);
            bl = true;
        }
        catch (Throwable var10) {
            try {
                Treasure.LOGGER.error("error reading resource: ", var10);
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    private void readTemplateFromStream(String id, InputStream stream, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
            nbttagcompound.func_74768_a("DataVersion", 500);
        }
        GottschTemplate template = new GottschTemplate();
        template.read(this.getFixer().func_188257_a((IFixType)FixTypes.STRUCTURE, nbttagcompound), markerBlocks, replacementBlocks);
        Treasure.LOGGER.debug("adding template to map with key -> {}", (Object)id);
        this.getTemplates().put(id, template);
    }

    public List<ResourceLocation> getResourceLocations(String modID, List<String> resources) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        resources.forEach(resource -> resourceLocations.add(new ResourceLocation(modID, resource)));
        return resourceLocations;
    }

    private void tableTemplate(String modID, ResourceLocation resourceLocation, Template template) {
        if (template != null) {
            Path path = Paths.get(resourceLocation.func_110623_a().toString(), new String[0]);
            ResourceLocation metaResourceLocation = new ResourceLocation(modID, "structures/" + path.getFileName().toString().replace(".nbt", ".json"));
            String key = metaResourceLocation.toString();
            Treasure.LOGGER.debug("Using key to find meta -> {}", (Object)key);
            StructureMeta meta = TreasureMetaRegistry.get(key);
            if (meta == null) {
                Treasure.LOGGER.info("Unable to locate meta file for resource -> {}", (Object)key);
                return;
            }
            if (meta.getArchetypes() == null || meta.getArchetypes().isEmpty() || meta.getType() == null) {
                Treasure.LOGGER.info("Meta file not properly configured. -> {}", (Object)key);
                return;
            }
            ArrayList<ResourceLocation> decayRuleSetResourceLocation = new ArrayList<ResourceLocation>();
            if (meta.getDecayRuleSetName() != null && meta.getDecayRuleSetName().size() > 0) {
                for (String ruleSetName : meta.getDecayRuleSetName()) {
                    ResourceLocation decayResourceLocation = new ResourceLocation(modID, "rulesets/" + ruleSetName + ".json");
                    decayRuleSetResourceLocation.add(decayResourceLocation);
                    Treasure.LOGGER.debug("Using key to find decay ruleset -> {}", (Object)((Object)decayRuleSetResourceLocation).toString());
                }
            }
            TemplateHolder holder = new TemplateHolder().setMetaLocation(metaResourceLocation).setLocation(resourceLocation).setDecayRuleSetLocation(decayRuleSetResourceLocation).setTemplate(template);
            this.getTemplatesByResourceLocationMap().put(resourceLocation, holder);
            for (IMetaArchetype archetype : meta.getArchetypes()) {
                Treasure.LOGGER.debug("Using meta to map archetype type -> {}", (Object)meta.toString());
                if (!this.templatesByArchetypeType.contains((Object)archetype, (Object)meta.getType())) {
                    this.templatesByArchetypeType.put((Object)archetype, (Object)meta.getType(), new ArrayList(3));
                }
                ((List)this.templatesByArchetypeType.get((Object)archetype, (Object)meta.getType())).add(holder);
                Treasure.LOGGER.debug("Registered holder -> location -> {}, meta -> {}, decay -> {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation(), holder.getDecayRuleSetLocation());
                this.mapToTemplatesByArchetypeBiome(metaResourceLocation, resourceLocation, decayRuleSetResourceLocation, archetype, meta.getType(), template);
            }
        } else {
            Treasure.LOGGER.debug("unable to table meta from -> {}", (Object)resourceLocation);
        }
    }

    private void createTemplateFolder(String modID) {
        Path folder = Paths.get(this.getWorldSaveFolder().getPath(), "data", "structures", modID).toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            Treasure.LOGGER.debug("template folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Treasure.LOGGER.warn("Unable to create template folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    @Deprecated
    public void register(String modID) {
        for (String location : FOLDER_LOCATIONS) {
            Treasure.LOGGER.debug("registering templates under location -> {}", (Object)location);
            List locs = this.getResourceLocations(modID, location);
            for (ResourceLocation loc : locs) {
                Path path = Paths.get(loc.func_110623_a(), new String[0]);
                if (Treasure.LOGGER.isDebugEnabled()) {
                    Treasure.LOGGER.debug("path to template resource loc -> {}", (Object)path.toString());
                }
                ResourceLocation metaResourceLocation = new ResourceLocation(this.getMod().getId() + ":meta/" + modID + "/structures/" + path.getFileName().toString().replace(".nbt", ".json"));
                String key = metaResourceLocation.toString();
                Treasure.LOGGER.debug("Using key to find meta -> {}", (Object)key);
                StructureMeta meta = TreasureMetaRegistry.get(key);
                if (meta == null) {
                    Treasure.LOGGER.info("Unable to locate meta file for resource -> {}", (Object)key);
                    continue;
                }
                if (meta.getArchetypes() == null || meta.getArchetypes().isEmpty() || meta.getType() == null) {
                    Treasure.LOGGER.info("Meta file not properly configured. -> {}", (Object)key);
                    continue;
                }
                Template template = this.load(loc, this.getMarkerScanList(), this.getReplacementMap());
                if (template == null) {
                    Treasure.LOGGER.debug("unable to load custom template  with key -> {}", (Object)loc.toString());
                    continue;
                }
                Treasure.LOGGER.debug("loaded custom template  with key -> {}", (Object)loc.toString());
                ArrayList<ResourceLocation> decayRuleSetResourceLocation = new ArrayList<ResourceLocation>();
                if (meta.getDecayRuleSetName() != null && meta.getDecayRuleSetName().size() > 0) {
                    for (String ruleSetName : meta.getDecayRuleSetName()) {
                        ResourceLocation resourceLocation = new ResourceLocation(this.getMod().getId(), "rulesets/" + ruleSetName + ".json");
                        decayRuleSetResourceLocation.add(resourceLocation);
                        Treasure.LOGGER.debug("Using key to find decay ruleset -> {}", (Object)((Object)decayRuleSetResourceLocation).toString());
                    }
                }
                TemplateHolder holder = new TemplateHolder().setMetaLocation(metaResourceLocation).setLocation(loc).setDecayRuleSetLocation(decayRuleSetResourceLocation).setTemplate(template);
                this.getTemplatesByResourceLocationMap().put(loc, holder);
                for (IMetaArchetype archetype : meta.getArchetypes()) {
                    Treasure.LOGGER.debug("Using meta to map archetype type -> {}", (Object)meta.toString());
                    if (!this.templatesByArchetypeType.contains((Object)archetype, (Object)meta.getType())) {
                        this.templatesByArchetypeType.put((Object)archetype, (Object)meta.getType(), new ArrayList(3));
                    }
                    ((List)this.templatesByArchetypeType.get((Object)archetype, (Object)meta.getType())).add(holder);
                    Treasure.LOGGER.debug("Registered holder -> location -> {}, meta -> {}, decay -> {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation(), holder.getDecayRuleSetLocation());
                    this.mapToTemplatesByArchetypeBiome(metaResourceLocation, loc, decayRuleSetResourceLocation, archetype, meta.getType(), template);
                }
            }
        }
        if (Treasure.LOGGER.isDebugEnabled()) {
            this.dump();
        }
    }

    private void mapToTemplatesByArchetypeBiome(ResourceLocation metaResourceLocation, ResourceLocation location, List<ResourceLocation> decayResourceLocation, IMetaArchetype archetype, IMetaType type, Template template) {
        block10: {
            Integer biomeID;
            TemplateHolder holder;
            StructureMeta meta;
            String key;
            block11: {
                block9: {
                    key = archetype.getName() + ":" + type.getName();
                    meta = TreasureMetaRegistry.get(metaResourceLocation.toString());
                    holder = new TemplateHolder().setMetaLocation(metaResourceLocation).setDecayRuleSetLocation(decayResourceLocation).setLocation(location).setTemplate(template);
                    if (!meta.getBiomeWhiteList().contains("*") && (!meta.getBiomeWhiteList().isEmpty() || !meta.getBiomeBlackList().isEmpty())) break block9;
                    Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
                    for (Biome biome : biomes) {
                        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                        Integer biomeID2 = Biome.func_185362_a((Biome)biome);
                        if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID2)) {
                            this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID2, new ArrayList(3));
                        }
                        ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID2)).add(holder);
                    }
                    break block10;
                }
                if (meta.getBiomeWhiteList().isEmpty()) break block11;
                for (String b : meta.getBiomeWhiteList()) {
                    String biomeName = b.trim().toLowerCase();
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                    if (biome == null) {
                        Treasure.LOGGER.debug("Unable to locate biome for name -> {}", (Object)biomeName);
                        continue;
                    }
                    if (biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                    Integer biomeID3 = Biome.func_185362_a((Biome)biome);
                    if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID3)) {
                        this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID3, new ArrayList(3));
                    }
                    ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID3)).add(holder);
                }
                break block10;
            }
            if (meta.getBiomeBlackList().isEmpty()) break block10;
            ArrayList<Integer> blackListBiomeIDs = new ArrayList<Integer>();
            for (String b : meta.getBiomeBlackList()) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(b.trim().toLowerCase()));
                if (biome != null) {
                    biomeID = Biome.func_185362_a((Biome)biome);
                    if (biomeID == null) continue;
                    blackListBiomeIDs.add(biomeID);
                    continue;
                }
                Treasure.LOGGER.debug("Unable to locate biome for name -> {}", (Object)b);
            }
            Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
            for (Biome biome : biomes) {
                if (blackListBiomeIDs.contains(Biome.func_185362_a((Biome)biome)) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                biomeID = Biome.func_185362_a((Biome)biome);
                if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID)) {
                    this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID, new ArrayList(3));
                }
                ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID)).add(holder);
            }
        }
    }

    public TemplateHolder getTemplate(World world, Random random, StructureArchetype archetype, StructureType type, Biome biome) {
        String key = archetype.getName() + ":" + type.getName();
        Integer biomeID = Biome.func_185362_a((Biome)biome);
        List templateHolders = (List)this.getTemplatesByArchetypeTypeBiomeTable().get((Object)key, (Object)biomeID);
        if (templateHolders == null || templateHolders.isEmpty()) {
            Treasure.LOGGER.debug("could not find template holders for archetype:type, biome -> {} {}", (Object)key, (Object)biomeID);
            return null;
        }
        TemplateHolder holder = (TemplateHolder)templateHolders.get(random.nextInt(templateHolders.size()));
        if (holder == null) {
            Treasure.LOGGER.debug("could not find random template holder.");
            return null;
        }
        Treasure.LOGGER.debug("selected template holder -> {} : {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation());
        return holder;
    }

    public GottschTemplateManager loadAll(List<String> locations) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        boolean bl;
        String s = id.func_110623_a();
        if (server == null || !this.getTemplates().containsKey(s)) return false;
        File file1 = new File(this.getBaseResourceFolder());
        if (!file1.exists() ? !file1.mkdirs() : !file1.isDirectory()) {
            return false;
        }
        File file2 = new File(file1, s + ".nbt");
        Template template = (Template)this.getTemplates().get(s);
        FileOutputStream outputstream = null;
        try {
            NBTTagCompound nbttagcompound = template.func_189552_a(new NBTTagCompound());
            outputstream = new FileOutputStream(file2);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
            bl = true;
        }
        catch (Throwable var13) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputstream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputstream);
        return bl;
    }

    public void dump() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyymmdd");
        String filename = String.format("treasure-template-mgr-%s.txt", formatter.format(new Date()));
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), "dumps").toAbsolutePath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            Treasure.LOGGER.error("Couldn't create directories for dump files:", (Throwable)e);
            return;
        }
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        String div = new String(chars) + "\n";
        StringBuilder sb = new StringBuilder();
        String format = "**    %1$-33s: %2$-30s  **\n";
        String format2 = "**    %1$-15s: %2$-15s: %3$-33s  **\n";
        String heading = "**  %1$-67s  **\n";
        sb.append(div).append(String.format("**  %-67s  **\n", "TEMPLATE MANAGER")).append(div).append(String.format(heading, "[Template By Type Map]"));
        for (Map.Entry entry : this.getTemplates().entrySet()) {
            sb.append(String.format(format, entry.getKey(), ((Template)entry.getValue()).func_186261_b()));
        }
        sb.append(div);
        sb.append(String.format(heading, "[Template by Archetype:Type | Biome]"));
        Map map = this.getTemplatesByArchetypeTypeBiomeTable().rowMap();
        if (map == null || map.isEmpty()) {
            Treasure.LOGGER.debug("template biome map is null/empty");
        }
        Treasure.LOGGER.debug("biome map.size -> {}", (Object)map.size());
        for (String row : map.keySet()) {
            Treasure.LOGGER.debug("template biome row key -> {}", (Object)row);
            Map tmp = (Map)map.get(row);
            for (Map.Entry entry : tmp.entrySet()) {
                String templateNames = ((List)entry.getValue()).stream().map(a -> a.getLocation().toString()).collect(Collectors.joining(", "));
                Biome biome = Biome.func_150568_d((int)((Integer)entry.getKey()));
                String biomeName = "";
                biomeName = biome != null ? (WorldInfo.isClientSide() ? biome.func_185359_l() : String.valueOf(Biome.func_185362_a((Biome)biome))) : String.format("No biome for {}", entry.getKey());
                sb.append(String.format(format2, row, biomeName, templateNames));
            }
        }
        try {
            Files.write(Paths.get(path.toString(), filename), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            Treasure.LOGGER.error("Error writing TreasureTemplateManager to dump file", (Throwable)iOException);
        }
    }

    public Map<ResourceLocation, TemplateHolder> getTemplatesByResourceLocationMap() {
        return this.templatesByResourceLocation;
    }

    public Table<String, Integer, List<TemplateHolder>> getTemplatesByArchetypeTypeBiomeTable() {
        return this.templatesByArchetypeTypeBiome;
    }

    public File getWorldSaveFolder() {
        return this.worldSaveFolder;
    }

    public void setWorldSaveFolder(File worldSaveFolder) {
        this.worldSaveFolder = worldSaveFolder;
    }
}

