/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.tileentity.AbstractProximityTileEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;

public class ProximitySpawnerTileEntity
extends AbstractProximityTileEntity {
    private ResourceLocation mobName;
    private Quantity mobNum;
    private Double spawnRange = 5.0;

    public ProximitySpawnerTileEntity() {
    }

    public ProximitySpawnerTileEntity(double proximity) {
        super(proximity);
    }

    @Override
    public void func_145839_a(NBTTagCompound sourceTag) {
        super.func_145839_a(sourceTag);
        try {
            this.mobName = sourceTag.func_150297_b("mobName", 8) ? new ResourceLocation(sourceTag.func_74779_i("mobName")) : DungeonHooks.getRandomDungeonMob((Random)new Random());
            if (this.getMobName() == null || StringUtils.func_151246_b((String)this.getMobName().toString())) {
                this.defaultMobSpawnerSettings();
                return;
            }
            int min = 1;
            boolean max = true;
            if (sourceTag.func_74764_b("mobNumMin")) {
                min = sourceTag.func_74762_e("mobNumMin");
            }
            if (sourceTag.func_74764_b("mobNumMax")) {
                min = sourceTag.func_74762_e("mobNumMax");
            }
            this.mobNum = new Quantity((double)min, (double)max);
            if (sourceTag.func_74764_b("spawnRange")) {
                Double spawnRange = sourceTag.func_74769_h("spawnRange");
                this.setSpawnRange(spawnRange);
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading ProximitySpanwer properties from NBT:", (Throwable)e);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound sourceTag) {
        super.func_189515_b(sourceTag);
        if (this.getMobName() == null || StringUtils.func_151246_b((String)this.getMobName().toString())) {
            this.defaultMobSpawnerSettings();
        }
        sourceTag.func_74778_a("mobName", this.getMobName().toString());
        sourceTag.func_74768_a("mobNumMin", this.getMobNum().getMinInt());
        sourceTag.func_74768_a("mobNumMax", this.getMobNum().getMaxInt());
        sourceTag.func_74780_a("spawnRange", this.getSpawnRange().doubleValue());
        return sourceTag;
    }

    private void defaultMobSpawnerSettings() {
        this.setMobName(new ResourceLocation("minecraft", "zombie"));
        this.setMobNum(new Quantity(1.0, 1.0));
        this.setSpawnRange(5.0);
    }

    @Override
    public void func_73660_a() {
        if (WorldInfo.isClientSide()) {
            return;
        }
        EntityPlayer player = null;
        boolean isTriggered = false;
        double proximitySq = this.getProximity() * this.getProximity();
        if (proximitySq < 1.0) {
            proximitySq = 1.0;
        }
        for (int playerIndex = 0; playerIndex < this.func_145831_w().field_73010_i.size(); ++playerIndex) {
            player = (EntityPlayer)this.func_145831_w().field_73010_i.get(playerIndex);
            double distanceSq = player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5));
            if (this.getMobName().func_110623_a().equals("bound_soul")) {
                Treasure.LOGGER.debug("PTE for mob -> {} @ -> {}, proximity -> {}, distance -> {}, triggered -> {}, dead -> {}, result -> {}", (Object)this.getMobName(), (Object)this.field_174879_c, (Object)proximitySq, (Object)distanceSq, (Object)isTriggered, (Object)this.isDead(), (Object)(!isTriggered && !this.isDead() && distanceSq < proximitySq ? "met" : "not met"));
            }
            if (!isTriggered && !this.isDead() && distanceSq < proximitySq) {
                Treasure.LOGGER.debug("PTE proximity was met.");
                isTriggered = true;
                this.execute(this.func_145831_w(), new Random(), new Coords(this.func_174877_v()), new Coords(player.func_180425_c()));
            }
            if (this.isDead()) break;
        }
    }

    @Override
    public void execute(World world, Random random, Coords blockCoords, Coords playerCoords) {
        int mobCount = RandomHelper.randomInt((Random)random, (int)this.getMobNum().getMinInt(), (int)this.getMobNum().getMaxInt());
        for (int i = 0; i < mobCount; ++i) {
            EntityLiving entityLiving;
            Entity entity = EntityList.func_188429_b((ResourceLocation)this.getMobName(), (World)world);
            if (entity == null) {
                Treasure.LOGGER.debug("unable to create entity -> {}", (Object)this.getMobName());
                this.selfDestruct();
                return;
            }
            double x = (double)blockCoords.getX() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * this.getSpawnRange() + 0.5;
            double y = blockCoords.getY();
            double z = (double)blockCoords.getZ() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * this.getSpawnRange() + 0.5;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            Treasure.LOGGER.debug("entity instanceof EntityLiving -> {}", (Object)(entity instanceof EntityLiving));
            if (!(entity instanceof EntityLiving) || !(entityLiving = (EntityLiving)entity).func_70601_bi() || !entityLiving.func_70058_J()) continue;
            entityLiving.field_70759_as = entityLiving.field_70177_z;
            entityLiving.field_70761_aq = entityLiving.field_70177_z;
            entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), (IEntityLivingData)null);
            world.func_72838_d(entity);
            entityLiving.func_70642_aH();
        }
        this.selfDestruct();
    }

    private void selfDestruct() {
        this.setDead(true);
        this.func_145831_w().func_175698_g(this.func_174877_v());
        this.func_145831_w().func_175713_t(this.func_174877_v());
    }

    public ResourceLocation getMobName() {
        return this.mobName;
    }

    public void setMobName(ResourceLocation mobName) {
        this.mobName = mobName;
    }

    public Quantity getMobNum() {
        return this.mobNum;
    }

    public void setMobNum(Quantity mobNum) {
        this.mobNum = mobNum;
    }

    public Double getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(Double spawnRange) {
        this.spawnRange = spawnRange;
    }
}

