/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.entity.monster.BoundSoulEntity;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GravestoneProximitySpawnerTileEntity
extends ProximitySpawnerTileEntity {
    private boolean hasEntity;

    public GravestoneProximitySpawnerTileEntity() {
        this.setProximity(20.0);
        this.setMobName(new ResourceLocation("treasure2", "bound_soul"));
        this.setMobNum(new Quantity(1.0, 1.0));
        this.setSpawnRange(3.0);
        this.setHasEntity(false);
    }

    @Override
    public void func_73660_a() {
        boolean hasEntity = this.hasEntity();
        if (hasEntity && TreasureConfig.WORLD_GEN.getMarkerProperties().isGravestoneSpawnMobAllowed) {
            if (WorldInfo.isClientSide()) {
                return;
            }
            EntityPlayer player = null;
            boolean isTriggered = false;
            double proximitySq = this.getProximity() * this.getProximity();
            if (proximitySq < 1.0) {
                proximitySq = 1.0;
            }
            for (int playerIndex = 0; playerIndex < this.func_145831_w().field_73010_i.size(); ++playerIndex) {
                player = (EntityPlayer)this.func_145831_w().field_73010_i.get(playerIndex);
                double distanceSq = player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5));
                if (!isTriggered && !this.isDead() && distanceSq < proximitySq) {
                    isTriggered = true;
                    this.execute(this.func_145831_w(), new Random(), new Coords(this.func_174877_v()), new Coords(player.func_180425_c()));
                }
                if (this.isDead()) break;
            }
        }
    }

    @Override
    public void execute(World world, Random random, Coords blockCoords, Coords playerCoords) {
        Treasure.LOGGER.debug("executing");
        int mobCount = RandomHelper.randomInt((Random)random, (int)this.getMobNum().getMinInt(), (int)this.getMobNum().getMaxInt());
        for (int i = 0; i < mobCount; ++i) {
            BoundSoulEntity entity = (BoundSoulEntity)EntityList.func_188429_b((ResourceLocation)this.getMobName(), (World)world);
            if (entity == null) {
                Treasure.LOGGER.debug("unable to create entity -> {}", (Object)this.getMobName());
                this.selfDestruct();
                return;
            }
            entity.func_175449_a(blockCoords.toPos(), 10);
            if (!(entity instanceof EntityLiving)) continue;
            double x = (double)blockCoords.getX() + world.field_73012_v.nextDouble() * this.getSpawnRange() - this.getSpawnRange() / 2.0 + 0.5;
            double y = blockCoords.getY();
            double z = (double)blockCoords.getZ() + world.field_73012_v.nextDouble() * this.getSpawnRange() - this.getSpawnRange() / 2.0 + 0.5;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            Treasure.LOGGER.debug("attempted location for bound soul spawn -> {} {} {}", (Object)x, (Object)y, (Object)z);
            BoundSoulEntity entityLiving = entity;
            for (int tries = 0; tries < 3; ++tries) {
                if (!entityLiving.func_70058_J()) {
                    Treasure.LOGGER.debug("collision - no spawn");
                }
                if (!entityLiving.func_70601_bi() || !entityLiving.func_70058_J()) continue;
                Treasure.LOGGER.debug("spawned bound soul");
                ((EntityLiving)entityLiving).field_70759_as = ((EntityLiving)entityLiving).field_70177_z;
                ((EntityLiving)entityLiving).field_70761_aq = ((EntityLiving)entityLiving).field_70177_z;
                entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), null);
                world.func_72838_d((Entity)entity);
                entityLiving.func_70642_aH();
                break;
            }
            this.setHasEntity(false);
        }
        this.selfDestruct();
    }

    private void selfDestruct() {
        Treasure.LOGGER.debug("self destructing.");
        this.setDead(true);
    }

    @Override
    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            if (parentNBT.func_150297_b("hasEntity", 8)) {
                this.hasEntity = parentNBT.func_74767_n("hasEntity");
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading AbstractProximity properties from NBT:", (Throwable)e);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("hasEntity", this.hasEntity());
        return tag;
    }

    public boolean hasEntity() {
        return this.hasEntity;
    }

    public void setHasEntity(boolean hasEntity) {
        this.hasEntity = hasEntity;
    }
}

