/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.tileentity.AbstractModTileEntity;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.enums.ChestGeneratorType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.inventory.AbstractChestContainer;
import com.someguyssoftware.treasure2.inventory.StandardChestContainer;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.ITreasureChestTileEntity;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class AbstractTreasureChestTileEntity
extends AbstractModTileEntity
implements ITreasureChestTileEntity,
ITickable {
    private List<LockState> lockStates;
    private int facing;
    private boolean sealed;
    private ResourceLocation lootTable;
    private GenerationContext generationContext;
    private int numberOfSlots = 27;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    public int ticksSinceSync;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.getNumberOfSlots(), (Object)ItemStack.field_190927_a);
    private String customName;

    public AbstractTreasureChestTileEntity() {
        this.setFacing(EnumFacing.NORTH.func_176745_a());
        this.setSealed(false);
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (WorldInfo.isServerSide((World)this.func_145831_w()) && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IInventory inventory;
                if (player.field_71070_bA instanceof AbstractChestContainer) {
                    inventory = ((AbstractChestContainer)player.field_71070_bA).getChestInventory();
                    if (inventory != this) continue;
                    ++this.numPlayersUsing;
                    continue;
                }
                if (!(player.field_71070_bA instanceof StandardChestContainer) || (inventory = ((StandardChestContainer)player.field_71070_bA).getChestInventory()) != this) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound parentNBT) {
        try {
            parentNBT = super.func_189515_b(parentNBT);
            this.writeLockStatesToNBT(parentNBT);
            this.writeInventoryToNBT(parentNBT);
            this.writePropertiesToNBT(parentNBT);
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error writing to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public NBTTagCompound writeLockStatesToNBT(NBTTagCompound parentNBT) {
        try {
            if (this.getLockStates() != null && !this.getLockStates().isEmpty()) {
                NBTTagList list = new NBTTagList();
                for (LockState state : this.getLockStates()) {
                    NBTTagCompound stateNBT = new NBTTagCompound();
                    state.writeToNBT(stateNBT);
                    list.func_74742_a((NBTBase)stateNBT);
                }
                parentNBT.func_74782_a("lockStates", (NBTBase)list);
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error writing LockStates to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public NBTTagCompound writePropertiesToNBT(NBTTagCompound sourceTag) {
        try {
            if (this.func_145818_k_()) {
                sourceTag.func_74778_a("CustomName", this.customName);
            }
            sourceTag.func_74768_a("facing", this.getFacing());
            sourceTag.func_74757_a("sealed", this.isSealed());
            if (this.getLootTable() != null) {
                sourceTag.func_74778_a("lootTable", this.getLootTable().toString());
            }
            if (this.getGenerationContext() != null) {
                NBTTagCompound contextTag = new NBTTagCompound();
                contextTag.func_74778_a("lootRarity", this.getGenerationContext().getLootRarity().getValue());
                contextTag.func_74778_a("chestGenType", this.getGenerationContext().getChestGeneratorType().name());
                sourceTag.func_74782_a("genContext", (NBTBase)contextTag);
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error writing Properties to NBT:", (Throwable)e);
        }
        return sourceTag;
    }

    public NBTTagCompound writeInventoryToNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191282_a((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error writing Inventory to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public void readInventoryFromNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191283_b((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading Properties from NBT:", (Throwable)e);
        }
    }

    public void readLockStatesFromNBT(NBTTagCompound parentNBT) {
        try {
            if (parentNBT.func_74764_b("lockStates")) {
                if (this.getLockStates() == null) {
                    this.setLockStates(new LinkedList<LockState>());
                }
                LinkedList<LockState> states = new LinkedList<LockState>();
                NBTTagList list = parentNBT.func_150295_c("lockStates", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound c = list.func_150305_b(i);
                    LockState lockState = LockState.readFromNBT(c);
                    states.add(lockState.getSlot().getIndex(), lockState);
                }
                this.setLockStates(states);
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading Lock States from NBT:", (Throwable)e);
        }
    }

    public void readPropertiesFromNBT(NBTTagCompound sourceTag) {
        try {
            if (sourceTag.func_150297_b("CustomName", 8)) {
                this.customName = sourceTag.func_74779_i("CustomName");
            }
            if (sourceTag.func_74764_b("facing")) {
                this.setFacing(sourceTag.func_74762_e("facing"));
            }
            if (sourceTag.func_74764_b("sealed")) {
                this.setSealed(sourceTag.func_74767_n("sealed"));
            }
            if (sourceTag.func_74764_b("lootTable") && !sourceTag.func_74779_i("lootTable").isEmpty()) {
                this.setLootTable(new ResourceLocation(sourceTag.func_74779_i("lootTable")));
            }
            if (sourceTag.func_74764_b("genContext")) {
                NBTTagCompound contextTag = sourceTag.func_74775_l("genContext");
                Rarity rarity = null;
                ChestGeneratorType genType = null;
                if (contextTag.func_74764_b("lootRarity")) {
                    rarity = Rarity.getByValue(contextTag.func_74779_i("lootRarity"));
                }
                if (contextTag.func_74764_b("chestGenType")) {
                    genType = ChestGeneratorType.valueOf(contextTag.func_74779_i("chestGenType"));
                }
                GenerationContext genContext = new GenerationContext(rarity, genType);
                this.setGenerationContext(genContext);
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading Properties from NBT:", (Throwable)e);
        }
    }

    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            this.readLockStatesFromNBT(parentNBT);
            this.readInventoryFromNBT(parentNBT);
            this.readPropertiesFromNBT(parentNBT);
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading to NBT:", (Throwable)e);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        try {
            this.readLockStatesFromNBT(nbt);
            this.readInventoryFromNBT(nbt);
            this.readPropertiesFromNBT(nbt);
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error reading to NBT:", (Throwable)e);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    @Override
    public List<LockState> getLockStates() {
        return this.lockStates;
    }

    @Override
    public void setLockStates(List<LockState> lockStates) {
        this.lockStates = lockStates;
    }

    @Override
    public boolean hasLocks() {
        if (this.getLockStates() == null || this.getLockStates().isEmpty()) {
            return false;
        }
        for (LockState state : this.getLockStates()) {
            if (state.getLock() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(int facing) {
        this.facing = facing;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.getCustomName() : "container.chest";
    }

    public boolean func_145818_k_() {
        return this.getCustomName() != null && this.getCustomName().length() > 0;
    }

    public int func_70302_i_() {
        if (!this.hasLocks()) {
            return this.getNumberOfSlots();
        }
        return 0;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (!this.hasLocks()) {
            return (ItemStack)this.getItems().get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (!this.hasLocks() && !(itemStack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count)).func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.hasLocks()) {
            return ItemStack.field_190927_a;
        }
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!this.hasLocks()) {
            this.getItems().set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        boolean isUsable = player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        return isUsable;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.hasLocks()) {
            return;
        }
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof TreasureChestBlock) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.getItems().clear();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    @Override
    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> chestContents) {
        this.items = chestContents;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    @Override
    public GenerationContext getGenerationContext() {
        return this.generationContext;
    }

    @Override
    public void setGenerationContext(GenerationContext context) {
        this.generationContext = context;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public class GenerationContext {
        private Rarity lootRarity;
        private ChestGeneratorType chestGeneratorType;

        public GenerationContext(Rarity rarity, ChestGeneratorType chestGeneratorType) {
            this.lootRarity = rarity;
            this.chestGeneratorType = chestGeneratorType;
        }

        public GenerationContext(ResourceLocation lootTable, Rarity rarity, ChestGeneratorType chestGeneratorType) {
            this.lootRarity = rarity;
            this.chestGeneratorType = chestGeneratorType;
        }

        public Rarity getLootRarity() {
            return this.lootRarity;
        }

        public ChestGeneratorType getChestGeneratorType() {
            return this.chestGeneratorType;
        }

        public ResourceLocation getLootTable() {
            return AbstractTreasureChestTileEntity.this.lootTable;
        }
    }
}

