/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SocketsRune
extends Rune {
    protected SocketsRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isSocketable();
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        if (!this.isValid(itemStack) || entity.isApplied()) {
            return;
        }
        if (itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
            Treasure.LOGGER.debug("adding socket to item -> {}, size -> {}", (Object)itemStack.func_82833_r(), (Object)cap.getMaxSocketSize());
            cap.addMaxSocketSize(1);
            entity.setApplied(true);
        }
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        if (cap.getMaxSocketSize() > 0) {
            cap.addMaxSocketSize(-1);
            for (int i = cap.getCharmEntities().get((Object)InventoryType.SOCKET).size() - 1; i > cap.getMaxSocketSize() - 1; --i) {
                cap.remove(InventoryType.SOCKET, i);
            }
        }
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new SocketsRune(this);
        }
    }
}

