/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class RuneEntity
implements IRuneEntity {
    private IRune runestone;
    private boolean applied;
    private List<String> appliedTo;

    public RuneEntity() {
    }

    public RuneEntity(IRuneEntity entity) {
        this.setRunestone(entity.getRunestone());
        this.setApplied(entity.isApplied());
        entity.getAppliedTo().forEach(type -> this.getAppliedTo().add((String)type));
    }

    @Override
    public boolean isAppliedTo(String type) {
        return this.getAppliedTo().contains(type);
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagCompound runestoneNbt = new NBTTagCompound();
        nbt.func_74782_a("runestone", (NBTBase)this.getRunestone().save(runestoneNbt));
        nbt.func_74757_a("applied", this.isApplied());
        NBTTagList list = new NBTTagList();
        this.getAppliedTo().forEach(type -> {
            NBTTagString s = new NBTTagString(type);
            list.func_74742_a((NBTBase)s);
        });
        nbt.func_74782_a("appliedTo", (NBTBase)list);
        return nbt;
    }

    @Override
    public IRune getRunestone() {
        return this.runestone;
    }

    @Override
    public void setRunestone(IRune runestone) {
        this.runestone = runestone;
    }

    public String toString() {
        return "RunestoneEntity [runestone=" + this.runestone + ", applied=" + this.applied + ", appliedTo=" + this.appliedTo + "]";
    }

    @Override
    public boolean isApplied() {
        return this.applied;
    }

    @Override
    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    @Override
    public List<String> getAppliedTo() {
        if (this.appliedTo == null) {
            this.appliedTo = new ArrayList<String>();
        }
        return this.appliedTo;
    }

    @Override
    public void setAppliedTo(List<String> appliedTo) {
        this.appliedTo = appliedTo;
    }
}

