/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.cost.QualityRuneCostReducerEvaluator;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class QualityRune
extends Rune {
    public static final double MULTIPLIER = 1.25;

    protected QualityRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        if (!this.isValid(itemStack)) {
            return;
        }
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.getCharmEntities().forEach((key, value) -> {
            if (!entity.isAppliedTo(value.getCharm().getType()) && !this.getInvalids().contains(value.getCharm().getType())) {
                value.setAmount(Math.floor(value.getAmount() * 1.25));
                value.setCostEvaluator(new QualityRuneCostReducerEvaluator());
                entity.getAppliedTo().add(value.getCharm().getType());
                entity.setApplied(true);
            }
        });
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.getCharmEntities().forEach((key, value) -> {
            if (entity.isAppliedTo(value.getCharm().getType())) {
                value.setAmount(Math.ceil(value.getAmount() / 1.25));
                entity.getAppliedTo().remove(value.getCharm().getType());
            }
        });
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new QualityRune(this);
        }
    }
}

