/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class PersistenceRune
extends Rune {
    protected PersistenceRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return EnchantmentHelper.func_190939_c((ItemStack)itemStack);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        Treasure.LOGGER.debug("applying persistence rune, isvalid -> {}, isapplied -> {}", (Object)this.isValid(itemStack), (Object)entity.isApplied());
        if (!this.isValid(itemStack) || entity.isApplied()) {
            return;
        }
        Treasure.LOGGER.debug("do we get here?");
        NBTTagList enchantmentTagList = itemStack.func_77986_q();
        int indexOfVanishing = -1;
        for (int i = 0; i < enchantmentTagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = enchantmentTagList.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)nbt.func_74765_d("id"));
            if (enchantment != Enchantments.field_190940_C) continue;
            indexOfVanishing = i;
            break;
        }
        if (indexOfVanishing > -1) {
            enchantmentTagList.func_74744_a(indexOfVanishing);
        }
        entity.setApplied(true);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        itemStack.func_77966_a(Enchantments.field_190940_C, 1);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new PersistenceRune(this);
        }
    }
}

