/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.ManaRune;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GreaterManaRune
extends ManaRune {
    protected GreaterManaRune(Builder builder) {
        super(builder);
    }

    @Override
    public void apply(ICharmEntity entity) {
        entity.setMana(entity.getMana() * 1.5);
        entity.setMaxMana(entity.getMaxMana() * 1.5);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.getCharmEntities().forEach((key, value) -> {
            if (entity.isAppliedTo(value.getCharm().getType())) {
                value.setMana(value.getMana() / 1.5);
                value.setMaxMana(value.getMaxMana() / 1.5);
                entity.getAppliedTo().remove(value.getCharm().getType());
            }
        });
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new GreaterManaRune(this);
        }
    }
}

