/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DoubleChargeRune
extends Rune {
    protected DoubleChargeRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null);
    }

    public void initCapabilityApply(ICharmableCapability capability, IRuneEntity entity) {
        this.process(capability, entity);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        if (!this.isValid(itemStack) || entity.isApplied()) {
            return;
        }
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        this.process(cap, entity);
    }

    protected void process(ICharmableCapability cap, IRuneEntity entity) {
        cap.getCharmEntities().forEach((key, value) -> {
            if (!entity.isAppliedTo(value.getCharm().getType()) && !this.getInvalids().contains(value.getCharm().getType())) {
                this.apply((ICharmEntity)value);
                entity.getAppliedTo().add(value.getCharm().getType());
                entity.setApplied(true);
            }
        });
    }

    protected void apply(ICharmEntity entity) {
        entity.setRecharges(entity.getRecharges() * 2);
        entity.setMaxRecharges(entity.getMaxRecharges() * 2);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.getCharmEntities().forEach((key, value) -> {
            if (entity.isAppliedTo(value.getCharm().getType())) {
                value.setRecharges(value.getRecharges() / 2);
                value.setMaxRecharges(value.getMaxRecharges() / 2);
                entity.getAppliedTo().remove(value.getCharm().getType());
            }
        });
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new DoubleChargeRune(this);
        }
    }
}

