/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.AegisCharm;
import com.someguyssoftware.treasure2.charm.GreaterHealingCharm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ShieldingCharm;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AngelsRune
extends Rune {
    protected AngelsRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.DURABILITY, null) && itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null);
    }

    public void initCapabilityApply(ICharmableCapability charmCap, IDurabilityCapability durabilityCap, IRuneEntity entity) {
        this.process(charmCap, durabilityCap, entity);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity runestoneEntity) {
        if (!this.isValid(itemStack)) {
            return;
        }
        IDurabilityCapability durabilityCap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
        durabilityCap.setInfinite(true);
        ICharmableCapability charmableCap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        this.process(charmableCap, durabilityCap, runestoneEntity);
    }

    protected void process(ICharmableCapability charmableCap, IDurabilityCapability durabilityCap, IRuneEntity runestoneEntity) {
        charmableCap.getCharmEntities().forEach((type, charmEntity) -> {
            if ((charmEntity.getCharm().getType().equals(HealingCharm.TYPE) || charmEntity.getCharm().getType().equals(GreaterHealingCharm.HEALING_TYPE) || charmEntity.getCharm().getType().equals(ShieldingCharm.SHIELDING_TYPE) || charmEntity.getCharm().getType().equals(AegisCharm.AEGIS_TYPE)) && !runestoneEntity.isAppliedTo(charmEntity.getCharm().getType())) {
                charmEntity.setMana(Math.floor(charmEntity.getMana() * 2.0));
                charmEntity.setMaxMana(Math.floor(charmEntity.getMaxMana() * 2.0));
                runestoneEntity.getAppliedTo().add(charmEntity.getCharm().getType());
            }
        });
        runestoneEntity.setApplied(true);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity runestoneEntity) {
        if (itemStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
            cap.setInfinite(false);
        }
        ICharmableCapability charmableCap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        charmableCap.getCharmEntities().forEach((type, charmEntity) -> {
            if ((charmEntity.getCharm().getType().equals(HealingCharm.TYPE) || charmEntity.getCharm().getType().equals(GreaterHealingCharm.HEALING_TYPE) || charmEntity.getCharm().getType().equals(ShieldingCharm.SHIELDING_TYPE) || charmEntity.getCharm().getType().equals(AegisCharm.AEGIS_TYPE)) && runestoneEntity.isAppliedTo(charmEntity.getCharm().getType())) {
                charmEntity.setMana(Math.floor(charmEntity.getMana() / 2.0));
                charmEntity.setMaxMana(Math.floor(charmEntity.getMaxMana() / 2.0));
                runestoneEntity.getAppliedTo().remove(charmEntity.getCharm().getType());
            }
        });
        runestoneEntity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new AngelsRune(this);
        }
    }
}

