/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;

public class WitherTreeRegistry {
    private static final String DIMENSION_ID_TAG_NAME = "dimensionID";
    private static final String WITHER_TREE_REGISTRY_TAG_NAME = "witherTreeRegistry";
    private static final String BIOME_ID_TAG_NAME = "biomeID";
    private static final String COORDS_TAG_NAME = "coords";
    private static WitherTreeRegistry instance = new WitherTreeRegistry();
    private Map<Integer, LinkedList<WitherTreeInfo>> registry = new HashMap<Integer, LinkedList<WitherTreeInfo>>();

    private WitherTreeRegistry() {
    }

    public static WitherTreeRegistry getInstance() {
        return instance;
    }

    public void register(Integer dimensionID, ICoords coords, Integer biomeID) {
        this.register(dimensionID, new WitherTreeInfo(coords, dimensionID, biomeID));
    }

    private synchronized void register(Integer dimensionID, WitherTreeInfo info) {
        LinkedList<WitherTreeInfo> witherTrees;
        Treasure.LOGGER.debug("Registering wither tree in dimension -> {}, info -> {}", (Object)dimensionID, (Object)info);
        if (!this.registry.containsKey(dimensionID)) {
            this.registry.put(dimensionID, new LinkedList());
        }
        if ((witherTrees = this.registry.get(dimensionID)).size() >= TreasureConfig.WITHER_TREE.witherTreeRegistrySize) {
            this.unregister(dimensionID);
        }
        witherTrees.add(info);
    }

    public synchronized void unregister(Integer dimensionID) {
        LinkedList<WitherTreeInfo> witherTrees;
        if (this.registry.containsKey(dimensionID) && (witherTrees = this.registry.get(dimensionID)).size() > 0) {
            witherTrees.pop();
        }
    }

    public WitherTreeInfo get(Integer dimensionID, int index) {
        LinkedList<WitherTreeInfo> list;
        WitherTreeInfo info = null;
        if (this.registry.containsKey(dimensionID) && index < (list = this.registry.get(dimensionID)).size()) {
            info = list.get(index);
        }
        return info;
    }

    public Set<Integer> getDimensionKeys() {
        return this.registry.keySet();
    }

    public LinkedList<WitherTreeInfo> getDimensionEntry(Integer dimensionID) {
        return this.registry.get(dimensionID);
    }

    public List<WitherTreeInfo> getValues(Integer dimensionID) {
        if (this.registry.containsKey(dimensionID)) {
            return new LinkedList<WitherTreeInfo>((Collection)this.registry.get(dimensionID));
        }
        return new ArrayList<WitherTreeInfo>();
    }

    public void clear() {
        this.registry.clear();
    }

    public void read(NBTTagCompound tag) {
        this.clear();
        NBTTagList witherTreeRegistryDimensionTagList = tag.func_150295_c(WITHER_TREE_REGISTRY_TAG_NAME, 10);
        for (int index = 0; index < witherTreeRegistryDimensionTagList.func_74745_c(); ++index) {
            NBTTagCompound dimTag = witherTreeRegistryDimensionTagList.func_150305_b(index);
            int dimensionID = dimTag.func_74762_e(DIMENSION_ID_TAG_NAME);
            NBTTagList infoTagList = dimTag.func_150295_c("infoList", 10);
            for (int infoIndex = 0; infoIndex < infoTagList.func_74745_c(); ++infoIndex) {
                NBTTagCompound infoTag = infoTagList.func_150305_b(infoIndex);
                int biomeID = infoTag.func_74762_e(BIOME_ID_TAG_NAME);
                NBTTagCompound coordsTag = infoTag.func_74775_l(COORDS_TAG_NAME);
                int x = coordsTag.func_74762_e("x");
                int y = coordsTag.func_74762_e("y");
                int z = coordsTag.func_74762_e("z");
                this.register(dimensionID, new WitherTreeInfo((ICoords)new Coords(x, y, z), dimensionID, biomeID));
            }
        }
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        NBTTagList witherTreeRegistryDimensionTagList = new NBTTagList();
        for (Integer dimensionKey : this.getDimensionKeys()) {
            LinkedList<WitherTreeInfo> infoList = this.getDimensionEntry(dimensionKey);
            NBTTagCompound dimTag = new NBTTagCompound();
            dimTag.func_74768_a(DIMENSION_ID_TAG_NAME, dimensionKey.intValue());
            NBTTagList infoTagList = new NBTTagList();
            for (WitherTreeInfo info : infoList) {
                NBTTagCompound infoTag = new NBTTagCompound();
                NBTTagInt biomeID = new NBTTagInt(info.getBiomeID().intValue());
                NBTTagCompound coords = new NBTTagCompound();
                NBTTagInt x = new NBTTagInt(info.getCoords().getX());
                NBTTagInt y = new NBTTagInt(info.getCoords().getY());
                NBTTagInt z = new NBTTagInt(info.getCoords().getZ());
                coords.func_74782_a("x", (NBTBase)x);
                coords.func_74782_a("y", (NBTBase)y);
                coords.func_74782_a("z", (NBTBase)z);
                infoTag.func_74782_a(BIOME_ID_TAG_NAME, (NBTBase)biomeID);
                infoTag.func_74782_a(COORDS_TAG_NAME, (NBTBase)coords);
                infoTagList.func_74742_a((NBTBase)infoTag);
            }
            dimTag.func_74782_a("infoList", (NBTBase)infoTagList);
            witherTreeRegistryDimensionTagList.func_74742_a((NBTBase)dimTag);
        }
        tag.func_82580_o(WITHER_TREE_REGISTRY_TAG_NAME);
        tag.func_74782_a(WITHER_TREE_REGISTRY_TAG_NAME, (NBTBase)witherTreeRegistryDimensionTagList);
        return tag;
    }

    public class WitherTreeInfo {
        private ICoords coords;
        private Integer dimensionID;
        private Integer biomeID;

        public WitherTreeInfo() {
        }

        public WitherTreeInfo(ICoords coords, Integer dimensionID, Integer biomeID) {
            this.coords = coords;
            this.dimensionID = dimensionID;
            this.biomeID = biomeID;
        }

        public ICoords getCoords() {
            return this.coords;
        }

        public void setCoords(ICoords coords) {
            this.coords = coords;
        }

        public Integer getDimensionID() {
            return this.dimensionID;
        }

        public void setDimensionID(Integer dimensionID) {
            this.dimensionID = dimensionID;
        }

        public Integer getBiomeID() {
            return this.biomeID;
        }

        public void setBiomeID(Integer biomeID) {
            this.biomeID = biomeID;
        }
    }
}

