/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.gottschcore.json.JSMin;
import com.someguyssoftware.treasure2.Treasure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public interface ITreasureResourceRegistry {
    public static <T> T readResourcesFromFromStream(InputStream inputStream, Class<T> resourceClass) throws IOException, Exception {
        Treasure.LOGGER.info("reading resources file from stream.");
        Object resources = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(inputStream, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            resources = gson.fromJson(jsonReader, resourceClass);
            Treasure.LOGGER.info("resources -> {}", resources);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to read master loot resources file:", e);
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                Treasure.LOGGER.warn("Unable to close JSON Reader when reading meta file.");
            }
        }
        return (T)resources;
    }
}

