/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.network.PoisonMistMessageToServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PoisonMistMessageHandlerOnServer
implements IMessageHandler<PoisonMistMessageToServer, IMessage> {
    public IMessage onMessage(final PoisonMistMessageToServer message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            Treasure.LOGGER.error("PoisonMistMessageToServer received on wrong side -> {}", (Object)ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            Treasure.LOGGER.warn("PoisonMistMessageToServer was invalid -> {}", (Object)message.toString());
            return null;
        }
        final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            Treasure.LOGGER.warn("EntityPlayerMP was null when PoisonMistMessageToServer was received.");
            return null;
        }
        WorldServer playerWorldServer = sendingPlayer.func_71121_q();
        playerWorldServer.func_152344_a(new Runnable(){

            @Override
            public void run() {
                PoisonMistMessageHandlerOnServer.this.processMessage(message, sendingPlayer);
            }
        });
        return null;
    }

    void processMessage(PoisonMistMessageToServer message, EntityPlayerMP sendingPlayer) {
        try {
            PotionEffect potionEffect;
            MinecraftServer minecraftServer = sendingPlayer.field_71133_b;
            EntityPlayerMP player = minecraftServer.func_184103_al().func_152612_a(message.getPlayerName());
            if (player != null && (potionEffect = player.func_70660_b(MobEffects.field_76436_u)) == null) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 0));
                Treasure.LOGGER.debug("poison potion effect is null, should be adding....");
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unexpected error ->", (Throwable)e);
        }
    }
}

