/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.CharmItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class RandomCharm
extends LootFunction {
    private static final ResourceLocation LOCATION = new ResourceLocation("treasure2:random_charm");
    private static final String LEVELS = "levels";
    private static final String RARITY = "rarity";
    private static final String RARITIES = "rarities";
    private static final String DEFAULT_CHARM = "defaultCharm";
    private static final String IS_BOOK = "isBook";
    private RandomValueRange levels;
    private Rarity rarity;
    private ICharm defaultCharm;
    private boolean isBook;

    public RandomCharm(LootCondition[] conditions, RandomValueRange levels, Rarity rarity, ICharm defaultCharm, boolean isBook) {
        super(conditions);
        this.levels = levels;
        this.rarity = rarity;
        this.defaultCharm = defaultCharm;
        this.isBook = isBook;
        Treasure.LOGGER.debug("rarity in constructor -> {}", (Object)rarity);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        Random random;
        Treasure.LOGGER.debug("incoming stack -> {}", (Object)stack.func_82833_r());
        ICharm defaultCharm = TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 1))).get();
        ICharm charm = this.defaultCharm == null ? defaultCharm : this.defaultCharm;
        Optional<Object> charms = Optional.empty();
        int level = this.levels == null ? 1 : this.levels.func_186511_a(rand);
        Treasure.LOGGER.debug("selected level -> {}", (Object)level);
        Treasure.LOGGER.debug("rarity -> {}", (Object)this.rarity);
        if (this.rarity != null) {
            charms = TreasureCharmRegistry.getBy(c -> c.getRarity() == this.rarity && !c.isCurse());
            if (charms.isPresent()) {
                random = new Random();
                charm = (ICharm)((List)charms.get()).get(random.nextInt(((List)charms.get()).size()));
                level = charm.getLevel();
                Treasure.LOGGER.debug("selected charm -> {}, level -> {}", (Object)charm.getName(), (Object)charm.getLevel());
            } else {
                charm = defaultCharm;
            }
        } else {
            charms = TreasureCharmRegistry.get(level);
            if (charms.isPresent()) {
                random = new Random();
                charm = (ICharm)((List)charms.get()).get(random.nextInt(((List)charms.get()).size()));
            } else {
                charm = defaultCharm;
            }
        }
        Treasure.LOGGER.debug("selected charm -> {}", (Object)charm.getName());
        ItemStack charmStack = null;
        if (this.isBook) {
            charmStack = new ItemStack((Item)TreasureItems.CHARM_BOOK);
        } else {
            CharmItem charmItem = TreasureItems.getCharmItemByLevel(level);
            charmStack = new ItemStack((Item)charmItem);
        }
        Treasure.LOGGER.debug("selected stack -> {}", (Object)charmStack.func_82833_r());
        ICharmableCapability cap = (ICharmableCapability)charmStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.clearCharms();
        cap.getCharmEntities().get((Object)InventoryType.INNATE).add(charm.createEntity());
        return charmStack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomCharm> {
        public Serializer() {
            super(LOCATION, RandomCharm.class);
        }

        public void serialize(JsonObject json, RandomCharm value, JsonSerializationContext context) {
            if (value.levels != null) {
                json.add(RandomCharm.LEVELS, context.serialize((Object)value.levels));
            }
            if (value.rarity != null) {
                json.add(RandomCharm.RARITY, (JsonElement)new JsonPrimitive(value.rarity.name()));
            }
            if (value.defaultCharm != null) {
                json.add(RandomCharm.DEFAULT_CHARM, (JsonElement)new JsonPrimitive(value.defaultCharm.getName().toString()));
            }
            json.add(RandomCharm.IS_BOOK, (JsonElement)new JsonPrimitive(Boolean.valueOf(value.isBook)));
        }

        public RandomCharm deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            RandomValueRange levels = null;
            if (json.has(RandomCharm.LEVELS)) {
                levels = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)RandomCharm.LEVELS, (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            Rarity rarity = null;
            if (json.has(RandomCharm.RARITY)) {
                String rarityString = JsonUtils.func_151200_h((JsonObject)json, (String)RandomCharm.RARITY);
                try {
                    rarity = Rarity.valueOf(rarityString.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.error("Unable to convert rarity {} to Rarity", (Object)rarityString);
                }
            }
            Optional<Object> charm = Optional.empty();
            if (json.has(RandomCharm.DEFAULT_CHARM)) {
                String charmName = JsonUtils.func_151200_h((JsonObject)json, (String)RandomCharm.DEFAULT_CHARM);
                charm = TreasureCharmRegistry.get(new ResourceLocation(charmName));
            }
            if (!charm.isPresent()) {
                charm = TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 1)));
            }
            boolean isBook = false;
            if (json.has(RandomCharm.IS_BOOK)) {
                isBook = JsonUtils.func_151212_i((JsonObject)json, (String)RandomCharm.IS_BOOK);
            }
            return new RandomCharm(conditionsIn, levels, rarity, (ICharm)charm.get(), isBook);
        }
    }
}

