/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot.function;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.charm.TreasureCharms;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class CharmRandomly
extends LootFunction {
    private static final String CHARM = "charm";
    private static final String LEVELS = "levels";
    private static final String RARITY = "rarity";
    private static final String RARITIES = "rarities";
    private static final String CURSE_CHANCE = "curseChance";
    private List<ICharm> charms;
    private RandomValueRange levels;
    private Rarity rarity;
    private InventoryType type;
    private RandomValueRange curseChance;

    public CharmRandomly(LootCondition[] conditions, @Nullable List<ICharm> charms, RandomValueRange levels, InventoryType type) {
        super(conditions);
        this.charms = charms == null ? Collections.emptyList() : charms;
        this.levels = levels;
        this.type = type;
    }

    public CharmRandomly(LootCondition[] conditions, @Nullable List<ICharm> charms, RandomValueRange levels, Rarity rarity, InventoryType type, RandomValueRange curseChance) {
        super(conditions);
        this.charms = charms == null ? Collections.emptyList() : charms;
        this.levels = levels;
        this.rarity = rarity;
        this.type = type;
        this.curseChance = curseChance;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int level;
        ICharm defaultCharm;
        Treasure.LOGGER.debug("incoming stack -> {}", (Object)stack.func_82833_r());
        if (!stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            return stack;
        }
        Treasure.LOGGER.debug("has charm cap");
        ICharm charm = defaultCharm = TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 1))).get();
        ICharmableCapability charmCap = (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null);
        ArrayList tempCharms = new ArrayList();
        int defaultLevel = charmCap.getMaxCharmLevel();
        Optional<Object> charmList = Optional.empty();
        int n = level = this.levels == null ? defaultLevel : this.levels.func_186511_a(rand);
        if (this.charms.isEmpty()) {
            if (this.rarity != null) {
                if (TreasureCharms.LEVEL_RARITY.get(charmCap.getMaxCharmLevel()).getCode() > this.rarity.getCode()) {
                    this.rarity = TreasureCharms.LEVEL_RARITY.get(charmCap.getMaxCharmLevel());
                }
                if ((charmList = TreasureCharmRegistry.get(this.rarity)).isPresent()) {
                    tempCharms.addAll((Collection)charmList.get());
                } else {
                    charm = defaultCharm;
                }
            } else if (this.levels != null) {
                int lambdaLevel = level;
                double curseProb = this.curseChance != null ? (double)this.levels.func_186511_a(rand) : 0.0;
                Treasure.LOGGER.debug("curse chance -> {}", (Object)curseProb);
                Optional<List<ICharm>> levelCharms = curseProb > 0.0 ? TreasureCharmRegistry.getBy(c -> {
                    if (c.isCurse()) {
                        return c.getLevel() == lambdaLevel && RandomHelper.checkProbability((Random)rand, (double)curseProb);
                    }
                    return c.getLevel() == lambdaLevel;
                }) : TreasureCharmRegistry.getBy(c -> c.getLevel() == lambdaLevel && !c.isCurse());
                if (levelCharms.isPresent()) {
                    tempCharms.addAll(levelCharms.get());
                }
            } else {
                Optional<List<ICharm>> defaultCharms = TreasureCharmRegistry.getBy(c -> c.getLevel() <= charmCap.getMaxCharmLevel() && !c.isCurse());
                if (defaultCharms.isPresent()) {
                    tempCharms.addAll(defaultCharms.get());
                }
            }
            Treasure.LOGGER.debug("temp charms size -> {}", (Object)tempCharms.size());
            if (!tempCharms.isEmpty()) {
                charm = (ICharm)tempCharms.get(rand.nextInt(tempCharms.size()));
                Treasure.LOGGER.debug("selected charm for item -> {}", (Object)charm.getName().toString());
            }
        } else {
            charm = this.charms.get(rand.nextInt(this.charms.size()));
            Treasure.LOGGER.debug("selected charm for item -> {}", (Object)charm.getName().toString());
        }
        if (charm == null) {
            return stack;
        }
        Treasure.LOGGER.debug("charm is not null -> {}", (Object)charm.getName());
        if (!charmCap.contains(charm)) {
            Treasure.LOGGER.debug("adding charm to charm instances - > {}", (Object)charm.getName().toString());
            charmCap.add(this.type, charm.createEntity());
        }
        Treasure.LOGGER.debug("returning charmed item -> {}", (Object)stack.func_82833_r());
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<CharmRandomly> {
        public Serializer() {
            super(new ResourceLocation("treasure2:charm_randomly"), CharmRandomly.class);
        }

        public void serialize(JsonObject json, CharmRandomly value, JsonSerializationContext context) {
            if (!value.charms.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (ICharm charm : value.charms) {
                    jsonArray.add((JsonElement)new JsonPrimitive(charm.getName().toString()));
                }
                json.add("charms", (JsonElement)jsonArray);
            }
            if (value.levels != null) {
                json.add(CharmRandomly.LEVELS, context.serialize((Object)value.levels));
            }
            if (value.rarity != null) {
                json.add(CharmRandomly.RARITY, (JsonElement)new JsonPrimitive(value.rarity.name()));
            }
            if (value.curseChance != null) {
                json.add(CharmRandomly.CURSE_CHANCE, context.serialize((Object)value.curseChance));
            }
        }

        public CharmRandomly deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            HashMap<String, ICharm> charmsByType = new HashMap<String, ICharm>(10);
            ArrayList list = Lists.newArrayList();
            RandomValueRange levels = null;
            if (json.has(CharmRandomly.LEVELS)) {
                levels = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)CharmRandomly.LEVELS, (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            Rarity rarity = null;
            if (json.has(CharmRandomly.RARITY)) {
                String rarityString = JsonUtils.func_151200_h((JsonObject)json, (String)CharmRandomly.RARITY);
                try {
                    rarity = Rarity.valueOf(rarityString.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.error("Unable to convert rarity {} to Rarity", (Object)rarityString);
                }
            }
            RandomValueRange curseChance = null;
            if (json.has(CharmRandomly.CURSE_CHANCE)) {
                curseChance = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)CharmRandomly.CURSE_CHANCE, (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            if (json.has("charms")) {
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"charms")) {
                    String charmName = JsonUtils.func_151206_a((JsonElement)element, (String)CharmRandomly.CHARM);
                    Optional<ICharm> charm = TreasureCharmRegistry.get(ResourceLocationUtil.create(charmName));
                    if (!charm.isPresent()) {
                        Treasure.LOGGER.warn("Unknown charm '{}'", (Object)charmName);
                    }
                    if (charmsByType.containsKey(charm.get().getType())) continue;
                    charmsByType.put(charm.get().getType(), charm.get());
                    list.add(charm.get());
                }
            }
            InventoryType type = InventoryType.INNATE;
            if (json.has("type")) {
                String typeString = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
                try {
                    type = InventoryType.valueOf(typeString.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.error("Unable to convert type {} to InventoryType", (Object)typeString);
                }
            }
            return new CharmRandomly(conditionsIn, list, levels, rarity, type, curseChance);
        }
    }
}

