/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.loot.LootResources;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.registry.ITreasureResourceRegistry;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TreasureLootTableRegistry {
    public static final Logger logger = LogManager.getLogger((String)Treasure.LOGGER.getName());
    private static final String LOOT_TABLES_FOLDER = "loot_tables";
    private static final List<String> REGISTERED_MODS;
    private static final Map<String, Boolean> LOADED_MODS;
    private static LootResources lootResources;
    private static TreasureLootTableMaster2 lootTableMaster;
    private static WorldServer world;

    private TreasureLootTableRegistry() {
    }

    @Deprecated
    public static synchronized void create(IMod mod) {
        if (lootTableMaster == null) {
            lootTableMaster = new TreasureLootTableMaster2(mod);
        }
    }

    public static void create(WorldServer world) {
        TreasureLootTableRegistry.world = world;
        lootTableMaster.init(world);
    }

    public static void register(String modID) {
        REGISTERED_MODS.add(modID);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (WorldInfo.isServerSide((World)event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            Treasure.LOGGER.debug("loot table registry world load");
            TreasureLootTableRegistry.create((WorldServer)event.getWorld());
            REGISTERED_MODS.forEach(mod -> {
                Treasure.LOGGER.debug("registering mod -> {}", mod);
                TreasureLootTableRegistry.load(mod);
            });
        }
    }

    public static void load(String modID) {
        if (LOADED_MODS.containsKey(modID)) {
            return;
        }
        LootResources lootResources = null;
        boolean worldSaveMetaLoaded = false;
        File lootResourcesFile = Paths.get(world.func_72860_G().func_75765_b().getPath(), "data", TreasureLootTableRegistry.getResourceFolder(), modID, "loot_tables_list.json").toFile();
        if (lootResourcesFile.exists() && lootResourcesFile.isFile()) {
            try {
                String json = Files.toString((File)lootResourcesFile, (Charset)StandardCharsets.UTF_8);
                lootResources = (LootResources)new GsonBuilder().create().fromJson(json, LootResources.class);
                worldSaveMetaLoaded = true;
                Treasure.LOGGER.debug("loaded {} loot resources from file system", (Object)TreasureLootTableRegistry.getResourceFolder());
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Couldn't load {} loot resources from {}", (Object)TreasureLootTableRegistry.getResourceFolder(), (Object)lootResourcesFile, (Object)e);
            }
        }
        if (!worldSaveMetaLoaded) {
            try {
                lootResources = ITreasureResourceRegistry.readResourcesFromFromStream(Objects.requireNonNull(((Object)((Object)Treasure.instance)).getClass().getClassLoader().getResourceAsStream("loot_tables/" + modID + "/loot_tables_list.json")), LootResources.class);
                Treasure.LOGGER.debug("loaded loot resources from jar");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Unable to loot resources");
            }
        }
        if (lootResources != null) {
            Treasure.LOGGER.warn("adding mod to loaded mods list");
            LOADED_MODS.put(modID, true);
            TreasureLootTableRegistry.register(modID, lootResources);
        }
    }

    private static String getResourceFolder() {
        return LOOT_TABLES_FOLDER;
    }

    public static void register(String modID, LootResources lootResources) {
        lootTableMaster.registerChests(modID, lootResources.getChestResources());
        lootTableMaster.registerChestsFromWorldSave(modID, lootResources.getChestLootTableFolderLocations());
        lootTableMaster.registerSpecials(modID, lootResources.getSpecialResources());
        lootTableMaster.registerSpecialsFromWorldSave(modID, lootResources.getSpecialLootTableFolderLocations());
        lootTableMaster.registerInjects(modID, lootResources.getInjectResources());
        lootTableMaster.registerInjectsFromWorldSave(modID, lootResources.getInjectLootTableFolderLocations());
    }

    public static List<String> getRegisteredMods() {
        return REGISTERED_MODS;
    }

    public static TreasureLootTableMaster2 getLootTableMaster() {
        return lootTableMaster;
    }

    public static void setLootTableMaster(TreasureLootTableMaster2 lootTableMaster) {
        TreasureLootTableRegistry.lootTableMaster = lootTableMaster;
    }

    static {
        lootTableMaster = new TreasureLootTableMaster2(null);
        REGISTERED_MODS = new ArrayList<String>();
        LOADED_MODS = Maps.newHashMap();
    }
}

