/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.RunestonesCapabilityProvider;
import com.someguyssoftware.treasure2.capability.RunestonesCapabilityStorage;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.rune.IRune;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.StringEscapeUtils;

public class RunestoneItem
extends ModItem {
    private static final RunestonesCapabilityStorage CAPABILITY_STORAGE = new RunestonesCapabilityStorage();

    public RunestoneItem(String modID, String name) {
        super(modID, name);
        this.func_77625_d(1);
        this.func_77637_a(Treasure.TREASURE_TAB);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        Treasure.LOGGER.debug("{} item initiating caps", (Object)stack.func_77973_b().getRegistryName().toString());
        RunestonesCapabilityProvider provider = new RunestonesCapabilityProvider();
        return provider;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"tooltip.runestones.usage"));
        IRunestonesCapability cap = this.getCap(stack);
        if (cap.hasRunestone()) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"tooltip.runestones.effects"));
            IRune runestone = cap.getEntities(InventoryType.INNATE).get(0).getRunestone();
            for (String s : StringEscapeUtils.unescapeJava((String)runestone.getLore()).split("\\R")) {
                tooltip.add(I18n.func_74837_a((String)"tooltip.indent2", (Object[])new Object[]{TextFormatting.LIGHT_PURPLE + "" + TextFormatting.ITALIC + s}));
            }
        }
    }

    public IRunestonesCapability getCap(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            return (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null);
        }
        throw new IllegalStateException();
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = (NBTTagCompound)CAPABILITY_STORAGE.writeNBT(TreasureCapabilities.RUNESTONES, (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null), null);
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt instanceof NBTTagCompound) {
            CAPABILITY_STORAGE.readNBT(TreasureCapabilities.RUNESTONES, (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null), null, (NBTBase)nbt);
        }
    }
}

