/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.ITreasureChestProxy;
import com.someguyssoftware.treasure2.enums.Category;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class LockItem
extends ModItem {
    private Category category;
    private Rarity rarity;
    private boolean craftable;
    private List<KeyItem> keys = new ArrayList<KeyItem>(3);

    public LockItem(String modID, String name, KeyItem[] keys) {
        this(modID, name);
        this.getKeys().addAll(Arrays.asList(keys));
    }

    public LockItem(String modID, String name) {
        this.setItemName(modID, name);
        this.setCategory(Category.ELEMENTAL);
        this.setRarity(Rarity.COMMON);
        this.setCraftable(false);
        this.func_77637_a(Treasure.TREASURE_TAB);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.rarity", (Object[])new Object[]{TextFormatting.DARK_BLUE + this.getRarity().toString()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.category", (Object[])new Object[]{this.getCategory()}));
        String craftable = "";
        craftable = this.isCraftable() ? TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.craftable", (Object[])new Object[]{craftable}));
        tooltip.add(I18n.func_74838_a((String)"tooltip.label.accepts_keys"));
        this.getKeys().forEach(key -> {
            String formattedKey = I18n.func_74837_a((String)(key.func_77658_a() + ".name"), (Object[])new Object[0]);
            tooltip.add(I18n.func_74837_a((String)("- " + TextFormatting.DARK_GREEN + formattedKey), (Object[])new Object[0]));
        });
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos chestPos = pos;
        Block block = worldIn.func_180495_p(chestPos).func_177230_c();
        if (block instanceof ITreasureChestProxy) {
            chestPos = ((ITreasureChestProxy)block).getChestPos(chestPos);
            block = worldIn.func_180495_p(chestPos).func_177230_c();
        }
        if (block instanceof AbstractChestBlock) {
            AbstractTreasureChestTileEntity tileEntity = (AbstractTreasureChestTileEntity)worldIn.func_175625_s(chestPos);
            if (WorldInfo.isClientSide((World)worldIn)) {
                return EnumActionResult.FAIL;
            }
            try {
                ItemStack heldItem = player.func_184586_b(hand);
                this.handleHeldLock(tileEntity, player, heldItem);
            }
            catch (Exception e) {
                Treasure.LOGGER.error("error: ", (Throwable)e);
            }
        }
        return super.func_180614_a(player, worldIn, chestPos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean handleHeldLock(AbstractTreasureChestTileEntity tileEntity, EntityPlayer player, ItemStack heldItem) {
        boolean lockedAdded = false;
        LockItem lock = (LockItem)heldItem.func_77973_b();
        for (LockState lockState : tileEntity.getLockStates()) {
            if (lockState == null || lockState.getLock() != null) continue;
            lockState.setLock(lock);
            tileEntity.sendUpdates();
            heldItem.func_190918_g(1);
            lockedAdded = true;
            break;
        }
        return lockedAdded;
    }

    public boolean acceptsKey(KeyItem keyItem) {
        for (KeyItem k : this.getKeys()) {
            if (k != keyItem) continue;
            return true;
        }
        return false;
    }

    public boolean breaksKey(KeyItem keyItem) {
        return false;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public LockItem setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public LockItem setCraftable(boolean craftable) {
        this.craftable = craftable;
        return this;
    }

    public List<KeyItem> getKeys() {
        return this.keys;
    }

    public LockItem setKeys(List<KeyItem> keys) {
        this.keys = keys;
        return this;
    }

    public String toString() {
        return "LockItem [name=" + this.getRegistryName() + ", rarity=" + (Object)((Object)this.rarity) + ", craftable=" + this.craftable + ", keys=" + this.keys + "]";
    }

    public Category getCategory() {
        return this.category;
    }

    public LockItem setCategory(Category category) {
        this.category = category;
        return this;
    }
}

