/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.capability.IKeyRingCapability;
import com.someguyssoftware.treasure2.capability.KeyRingCapabilityProvider;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.inventory.KeyRingInventory;
import com.someguyssoftware.treasure2.item.IKeyEffects;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.ITreasureChestTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class KeyRingItem
extends ModItem
implements IKeyEffects {
    private int keyRingGuiID = 3;

    public KeyRingItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        KeyRingCapabilityProvider provider = new KeyRingCapabilityProvider();
        return provider;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.key_ring", (Object[])new Object[]{TextFormatting.GOLD}));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean isKeyBroken = false;
        if (WorldInfo.isClientSide((World)worldIn)) {
            return EnumActionResult.FAIL;
        }
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block instanceof TreasureChestBlock) {
            IKeyRingCapability capability;
            TileEntity te = worldIn.func_175625_s(pos);
            if (te == null || !(te instanceof ITreasureChestTileEntity)) {
                Treasure.LOGGER.warn("Null or incorrect TileEntity");
                return EnumActionResult.FAIL;
            }
            ITreasureChestTileEntity tcte = (ITreasureChestTileEntity)te;
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.hasCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null) && (capability = (IKeyRingCapability)heldItem.getCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null)) != null) {
                capability.setUsedOnChest(true);
            }
            if (!tcte.hasLocks()) {
                return EnumActionResult.SUCCESS;
            }
            try {
                IItemHandler cap = null;
                if (heldItem.hasCapability(KeyRingCapabilityProvider.KEY_RING_INVENTORY_CAPABILITY, null)) {
                    cap = (IItemHandler)heldItem.getCapability(KeyRingCapabilityProvider.KEY_RING_INVENTORY_CAPABILITY, null);
                }
                if (cap == null) {
                    return EnumActionResult.PASS;
                }
                for (int i = 0; i < KeyRingInventory.INVENTORY_SIZE; ++i) {
                    ItemStack keyStack = cap.getStackInSlot(i);
                    if (keyStack == null || keyStack.func_77973_b() == Items.field_190931_a) continue;
                    KeyItem key = (KeyItem)keyStack.func_77973_b();
                    Treasure.LOGGER.debug("Using key from keyring: {}", (Object)key.func_77658_a());
                    boolean breakKey = true;
                    boolean fitsLock = false;
                    LockState lockState = null;
                    lockState = key.fitsFirstLock(tcte.getLockStates());
                    if (lockState != null) {
                        fitsLock = true;
                    }
                    Treasure.LOGGER.debug("key fits lock: {}", (Object)lockState);
                    if (!fitsLock) continue;
                    if (key.unlock(lockState.getLock())) {
                        LockItem lock = lockState.getLock();
                        this.doKeyUnlockEffects(worldIn, player, pos, tcte, lockState);
                        lockState.setLock(null);
                        tcte.sendUpdates();
                        if (TreasureConfig.KEYS_LOCKS.enableLockDrops) {
                            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
                        }
                        breakKey = false;
                    }
                    if (breakKey) {
                        if ((key.isBreakable() || key.anyLockBreaksKey(tcte.getLockStates(), key)) && TreasureConfig.KEYS_LOCKS.enableKeyBreaks) {
                            keyStack.func_190918_g(1);
                            isKeyBroken = true;
                            if (keyStack.func_190916_E() > 0) {
                                keyStack.func_77964_b(0);
                            }
                            key.doKeyBreakEffects(worldIn, player, pos, tcte);
                        } else if (!fitsLock) {
                            this.doKeyNotFitEffects(worldIn, player, pos, tcte);
                        } else {
                            this.doKeyUnableToUnlockEffects(worldIn, player, pos, tcte);
                        }
                    }
                    if (key.func_77645_m() && !isKeyBroken) {
                        keyStack.func_77972_a(1, (EntityLivingBase)player);
                    } else {
                        Treasure.LOGGER.debug("Key in keyring is NOT damageable.");
                    }
                    break;
                }
            }
            catch (Exception e) {
                Treasure.LOGGER.error("error: ", (Throwable)e);
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (WorldInfo.isClientSide((World)worldIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        boolean useOnChest = false;
        ItemStack stack = playerIn.func_184586_b(handIn);
        IKeyRingCapability cap = null;
        if (stack.hasCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null) && (cap = (IKeyRingCapability)stack.getCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null)) != null) {
            useOnChest = cap.isUsedOnChest();
        }
        if (useOnChest) {
            cap.setUsedOnChest(false);
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        BlockPos pos = playerIn.func_180425_c();
        playerIn.openGui((Object)Treasure.instance, this.getKeyRingGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        IKeyRingCapability cap = null;
        if (stack.hasCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null)) {
            cap = (IKeyRingCapability)stack.getCapability(KeyRingCapabilityProvider.KEY_RING_CAPABILITY, null);
        }
        if (cap != null && cap.isOpen()) {
            return false;
        }
        return super.onDroppedByPlayer(stack, player);
    }

    public int getKeyRingGuiID() {
        return this.keyRingGuiID;
    }

    public void setKeyRingGuiID(int keyRingGuiID) {
        this.keyRingGuiID = keyRingGuiID;
    }
}

