/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.ITreasureChestProxy;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.DurabilityCapabilityProvider;
import com.someguyssoftware.treasure2.capability.DurabilityCapabilityStorage;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Category;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.IKeyEffects;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class KeyItem
extends ModItem
implements IKeyEffects {
    public static final int DEFAULT_MAX_USES = 25;
    private Category category;
    private Rarity rarity;
    private boolean craftable;
    private boolean breakable;
    private boolean damageable;
    private double successProbability;
    private static final DurabilityCapabilityStorage CAPABILITY_STORAGE = new DurabilityCapabilityStorage();

    public KeyItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.setCategory(Category.ELEMENTAL);
        this.setRarity(Rarity.COMMON);
        this.setBreakable(true);
        this.setDamageable(true);
        this.setCraftable(false);
        this.setMaxDamage(25);
        this.setSuccessProbability(95.0);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        DurabilityCapabilityProvider provider = new DurabilityCapabilityProvider();
        IDurabilityCapability cap = provider.getCapability(TreasureCapabilities.DURABILITY, null);
        cap.setDurability(this.func_77612_l());
        return provider;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound nbt = null;
        nbt = (NBTTagCompound)CAPABILITY_STORAGE.writeNBT(TreasureCapabilities.DURABILITY, (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null), null);
        return nbt;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        CAPABILITY_STORAGE.readNBT(TreasureCapabilities.DURABILITY, (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null), null, (NBTBase)nbt);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.rarity", (Object[])new Object[]{TextFormatting.DARK_BLUE + this.getRarity().toString()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.category", (Object[])new Object[]{this.getCategory()}));
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            DurabilityCapability cap = (DurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
            tooltip.add(I18n.func_74837_a((String)"tooltip.label.uses", (Object[])new Object[]{cap.getDurability() - stack.func_77952_i(), cap.getDurability()}));
        }
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.max_uses", (Object[])new Object[]{this.func_77612_l()}));
        String breakable = "";
        breakable = this.isBreakable() ? TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.breakable", (Object[])new Object[]{breakable}));
        String craftable = "";
        craftable = this.isCraftable() ? TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.craftable", (Object[])new Object[]{craftable}));
        String damageable = "";
        damageable = this.func_77645_m() ? TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.damageable", (Object[])new Object[]{damageable}));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            DurabilityCapability cap = (DurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
            return (double)stack.func_77952_i() / (double)cap.getDurability();
        }
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack resourceItem) {
        return itemToRepair.func_77951_h() && itemToRepair.func_77973_b() == this && resourceItem.func_77973_b() == this;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos chestPos = pos;
        Block block = worldIn.func_180495_p(chestPos).func_177230_c();
        if (block instanceof ITreasureChestProxy) {
            chestPos = ((ITreasureChestProxy)block).getChestPos(chestPos);
            block = worldIn.func_180495_p(chestPos).func_177230_c();
        }
        if (block instanceof AbstractChestBlock) {
            TileEntity tileEntity = worldIn.func_175625_s(chestPos);
            if (tileEntity == null || !(tileEntity instanceof AbstractTreasureChestTileEntity)) {
                Treasure.LOGGER.warn("Null or incorrect TileEntity");
                return EnumActionResult.FAIL;
            }
            AbstractTreasureChestTileEntity chestTileEntity = (AbstractTreasureChestTileEntity)tileEntity;
            if (WorldInfo.isClientSide((World)worldIn)) {
                return EnumActionResult.FAIL;
            }
            if (!chestTileEntity.hasLocks()) {
                return EnumActionResult.SUCCESS;
            }
            try {
                ItemStack heldItemStack = player.func_184586_b(hand);
                boolean breakKey = true;
                boolean fitsLock = false;
                LockState lockState = null;
                boolean isKeyBroken = false;
                lockState = this.fitsFirstLock(chestTileEntity.getLockStates());
                if (lockState != null) {
                    fitsLock = true;
                }
                if (fitsLock && this.unlock(lockState.getLock())) {
                    LockItem lock = lockState.getLock();
                    this.doKeyUnlockEffects(worldIn, player, chestPos, chestTileEntity, lockState);
                    lockState.setLock(null);
                    chestTileEntity.sendUpdates();
                    if (!this.breaksLock(lock) && TreasureConfig.KEYS_LOCKS.enableLockDrops) {
                        InventoryHelper.func_180173_a((World)worldIn, (double)chestPos.func_177958_n(), (double)chestPos.func_177956_o(), (double)chestPos.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
                    }
                    breakKey = false;
                }
                IDurabilityCapability cap = (IDurabilityCapability)heldItemStack.getCapability(TreasureCapabilities.DURABILITY, null);
                if (breakKey) {
                    if ((this.isBreakable() || this.anyLockBreaksKey(chestTileEntity.getLockStates(), this)) && TreasureConfig.KEYS_LOCKS.enableKeyBreaks) {
                        int damage = heldItemStack.func_77952_i() + (this.func_77612_l() - heldItemStack.func_77952_i() % this.func_77612_l());
                        heldItemStack.func_77964_b(damage);
                        if (heldItemStack.func_77952_i() >= cap.getDurability()) {
                            heldItemStack.func_190918_g(1);
                        }
                        this.doKeyBreakEffects(worldIn, player, chestPos, chestTileEntity);
                        isKeyBroken = true;
                    } else if (!fitsLock) {
                        this.doKeyNotFitEffects(worldIn, player, chestPos, chestTileEntity);
                    } else {
                        this.doKeyUnableToUnlockEffects(worldIn, player, chestPos, chestTileEntity);
                    }
                }
                if (this.func_77645_m() && !isKeyBroken) {
                    heldItemStack.func_77964_b(heldItemStack.func_77952_i() + 1);
                    if (heldItemStack.func_77952_i() >= cap.getDurability()) {
                        heldItemStack.func_190918_g(1);
                    }
                }
            }
            catch (Exception e) {
                Treasure.LOGGER.error("error: ", (Throwable)e);
            }
        }
        return super.func_180614_a(player, worldIn, chestPos, hand, facing, hitX, hitY, hitZ);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public boolean fitsLock(LockItem lockItem) {
        return false;
    }

    public LockState fitsFirstLock(List<LockState> lockStates) {
        LockState lockState = null;
        for (LockState ls : lockStates) {
            if (ls.getLock() == null || !(lockState = ls).getLock().acceptsKey(this) && !this.fitsLock(lockState.getLock())) continue;
            return ls;
        }
        return null;
    }

    public boolean anyLockBreaksKey(List<LockState> lockStates, KeyItem key) {
        for (LockState ls : lockStates) {
            if (ls.getLock() == null || !ls.getLock().breaksKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean unlock(LockItem lockItem) {
        if (lockItem.acceptsKey(this) || this.fitsLock(lockItem)) {
            Treasure.LOGGER.debug("Lock -> {} accepts key -> {}", (Object)lockItem.getRegistryName(), (Object)this.getRegistryName());
            if (RandomHelper.checkProbability((Random)new Random(), (double)this.getSuccessProbability())) {
                Treasure.LOGGER.debug("Unlock attempt met probability");
                return true;
            }
        }
        return false;
    }

    public boolean breaksLock(LockItem lockItem) {
        return false;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public KeyItem setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public KeyItem setCraftable(boolean craftable) {
        this.craftable = craftable;
        return this;
    }

    public String toString() {
        return "KeyItem [rarity=" + (Object)((Object)this.rarity) + ", craftable=" + this.craftable + "]";
    }

    public Category getCategory() {
        return this.category;
    }

    public KeyItem setCategory(Category category) {
        this.category = category;
        return this;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public KeyItem setBreakable(boolean breakable) {
        this.breakable = breakable;
        return this;
    }

    public KeyItem setMaxDamage(int damage) {
        super.func_77656_e(damage);
        return this;
    }

    public double getSuccessProbability() {
        return this.successProbability;
    }

    public KeyItem setSuccessProbability(double successProbability) {
        this.successProbability = successProbability;
        return this;
    }

    public boolean func_77645_m() {
        return this.damageable;
    }

    public void setDamageable(boolean damageable) {
        this.damageable = damageable;
    }
}

