/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;

public interface IWishable {
    public static final String DROPPED_BY_KEY = "droppedBy";

    public Optional<ItemStack> generateLoot(World var1, Random var2, ItemStack var3, ICoords var4);

    default public void injectLoot(World world, Random random, List<ItemStack> itemStacks, String category, Rarity rarity, LootContext lootContext) {
        Optional<List<LootTableShell>> injectLootTableShells = this.buildInjectedLootTableList(category, rarity);
        if (injectLootTableShells.isPresent()) {
            itemStacks.addAll(TreasureLootTableRegistry.getLootTableMaster().getInjectedLootItems(world, random, injectLootTableShells.get(), lootContext));
        }
    }

    default public Optional<List<LootTableShell>> buildInjectedLootTableList(String key, Rarity rarity) {
        return Optional.ofNullable(TreasureLootTableRegistry.getLootTableMaster().getLootTableByKeyRarity(TreasureLootTableMaster2.ManagedTableType.INJECT, key, rarity));
    }

    default public List<LootTableShell> getLootTables() {
        return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.COMMON);
    }

    default public ItemStack getDefaultLootKey(Random random) {
        ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.COMMON));
        return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
    }

    default public Rarity getDefaultEffectiveRarity(Random random) {
        return Rarity.UNCOMMON;
    }

    @Deprecated
    default public LootContext getLootContext() {
        return TreasureLootTableRegistry.getLootTableMaster().getContext();
    }

    default public LootContext getLootContext(World world, EntityPlayer player) {
        if (player == null) {
            return this.getLootContext();
        }
        LootContext lootContext = new LootContext.Builder((WorldServer)world).func_186469_a(player != null ? player.func_184817_da() : 0.0f).func_186470_a(player).func_186471_a();
        return lootContext;
    }
}

