/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.CharmableCapabilityProvider;
import com.someguyssoftware.treasure2.capability.CharmableCapabilityStorage;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CharmItem
extends ModItem {
    private static final CharmableCapabilityStorage CAPABILITY_STORAGE = new CharmableCapabilityStorage();

    public CharmItem(String modID, String name) {
        super(modID, name);
        this.func_77625_d(1);
        this.func_77637_a(Treasure.TREASURE_TAB);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        Treasure.LOGGER.debug("{} item initiating caps", (Object)stack.func_77973_b().getRegistryName().toString());
        CharmableCapabilityProvider provider = new CharmableCapabilityProvider();
        return provider;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"tooltip.charmable.usage"));
        ICharmableCapability cap = this.getCap(stack);
        if (cap.isCharmed()) {
            cap.appendHoverText(stack, worldIn, tooltip, flagIn);
        }
    }

    public ICharmableCapability getCap(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            return (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null);
        }
        throw new IllegalStateException();
    }

    public boolean func_77636_d(ItemStack stack) {
        ICharmableCapability cap = this.getCap(stack);
        return cap.isCharmed();
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound charmableTag = (NBTTagCompound)CAPABILITY_STORAGE.writeNBT(TreasureCapabilities.CHARMABLE, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null), null);
        return charmableTag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt instanceof NBTTagCompound) {
            CAPABILITY_STORAGE.readNBT(TreasureCapabilities.CHARMABLE, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null), null, (NBTBase)nbt);
        }
    }
}

