/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.AdornmentSize;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.capability.AdornmentCapabilityProvider;
import com.someguyssoftware.treasure2.capability.CharmableCapabilityStorage;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.DurabilityCapabilityStorage;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.RunestonesCapabilityStorage;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.enums.AdornmentType;
import com.someguyssoftware.treasure2.integration.baubles.BaublesIntegration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class Adornment
extends ModItem {
    private static final CharmableCapabilityStorage CAPABILITY_STORAGE = new CharmableCapabilityStorage();
    private static final RunestonesCapabilityStorage RUNESTONES_STORAGE = new RunestonesCapabilityStorage();
    private static final DurabilityCapabilityStorage DURABILITY_STORAGE = new DurabilityCapabilityStorage();
    private AdornmentType type;
    private AdornmentSize size;

    public Adornment(String modID, String name, AdornmentType type) {
        this(modID, name, type, TreasureAdornmentRegistry.STANDARD);
    }

    public Adornment(String modID, String name, AdornmentType type, AdornmentSize size) {
        super(modID, name);
        this.setType(type);
        this.setSize(size);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.func_77637_a(Treasure.ADORNMENTS_TAB);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(this.type) : new AdornmentCapabilityProvider();
    }

    public ICharmableCapability getCap(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            return (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null);
        }
        throw new IllegalStateException();
    }

    public IDurabilityCapability getDurabilityCap(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            return (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
        }
        throw new IllegalStateException();
    }

    public IRunestonesCapability getRunestonesCap(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            return (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null);
        }
        throw new IllegalStateException();
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return name;
    }

    public boolean func_77636_d(ItemStack stack) {
        ICharmableCapability cap = this.getCap(stack);
        return cap.isCharmed();
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TextFormatting.GOLD.toString() + "" + TextFormatting.ITALIC.toString() + I18n.func_74838_a((String)"tooltip.charmable.usage.adornment"));
        this.getDurabilityCap(stack).appendHoverText(stack, world, tooltip, flag);
        this.getCap(stack).appendHoverText(stack, world, tooltip, flag);
        if (stack.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            this.getRunestonesCap(stack).appendHoverText(stack, world, tooltip, flag);
        }
        if (this.getCap(stack).getSourceItem() == Items.field_190931_a.getRegistryName() || this.getCap(stack).getSourceItem() == null) {
            tooltip.add(TextFormatting.WHITE.toString() + "" + TextFormatting.ITALIC.toString() + I18n.func_74838_a((String)"tooltip.adornment.upgradable"));
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound charmableTag = (NBTTagCompound)CAPABILITY_STORAGE.writeNBT(TreasureCapabilities.CHARMABLE, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null), null);
        NBTTagCompound runestonesTag = (NBTTagCompound)RUNESTONES_STORAGE.writeNBT(TreasureCapabilities.RUNESTONES, (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null), null);
        NBTTagCompound durabilityTag = (NBTTagCompound)DURABILITY_STORAGE.writeNBT(TreasureCapabilities.DURABILITY, (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null), null);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("charmable", (NBTBase)charmableTag);
        tag.func_74782_a("runestones", (NBTBase)runestonesTag);
        tag.func_74782_a("durability", (NBTBase)durabilityTag);
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        NBTTagCompound tag;
        super.readNBTShareTag(stack, nbt);
        Treasure.LOGGER.debug("reading share tag");
        if (nbt == null) {
            Treasure.LOGGER.debug("nbt is null - how?");
            return;
        }
        if (nbt.func_74764_b("charmable")) {
            tag = nbt.func_74775_l("charmable");
            CAPABILITY_STORAGE.readNBT(TreasureCapabilities.CHARMABLE, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null), null, (NBTBase)tag);
        }
        if (nbt.func_74764_b("runestones")) {
            tag = nbt.func_74775_l("runestones");
            RUNESTONES_STORAGE.readNBT(TreasureCapabilities.RUNESTONES, (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null), null, (NBTBase)tag);
        }
        if (nbt.func_74764_b("durability")) {
            tag = nbt.func_74775_l("durability");
            DURABILITY_STORAGE.readNBT(TreasureCapabilities.DURABILITY, (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null), null, (NBTBase)tag);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            DurabilityCapability cap = (DurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
            if (cap.isInfinite()) {
                return 0.0;
            }
            return (double)stack.func_77952_i() / (double)cap.getDurability();
        }
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public AdornmentType getType() {
        return this.type;
    }

    private void setType(AdornmentType type) {
        this.type = type;
    }

    public AdornmentSize getSize() {
        return this.size;
    }

    private void setSize(AdornmentSize size) {
        this.size = size;
    }
}

