/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.integration.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import com.google.common.collect.Lists;
import com.someguyssoftware.treasure2.capability.AdornmentCapabilityProvider;
import com.someguyssoftware.treasure2.capability.CharmableCapability;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.RunestonesCapability;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.AdornmentType;
import com.someguyssoftware.treasure2.item.Adornment;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.Loader;

public class BaublesIntegration {
    public static final String BAUBLES_MOD_ID = "baubles";
    public static final List<Integer> BAUBLES_SLOTS = Lists.newArrayList();
    public static final Map<AdornmentType, BaubleType> TREASURE_BAUBLE_TYPE_MAP = new EnumMap<AdornmentType, BaubleType>(AdornmentType.class);
    private static boolean baublesLoaded;

    public static void init() {
        baublesLoaded = Loader.isModLoaded((String)BAUBLES_MOD_ID);
        if (!BaublesIntegration.isEnabled()) {
            return;
        }
        BAUBLES_SLOTS.addAll(IntStream.of(BaubleType.AMULET.getValidSlots()).boxed().collect(Collectors.toList()));
        BAUBLES_SLOTS.addAll(IntStream.of(BaubleType.RING.getValidSlots()).boxed().collect(Collectors.toList()));
        BAUBLES_SLOTS.addAll(IntStream.of(BaubleType.BODY.getValidSlots()).boxed().collect(Collectors.toList()));
        BAUBLES_SLOTS.addAll(IntStream.of(BaubleType.CHARM.getValidSlots()).boxed().collect(Collectors.toList()));
        TREASURE_BAUBLE_TYPE_MAP.put(AdornmentType.RING, BaubleType.RING);
        TREASURE_BAUBLE_TYPE_MAP.put(AdornmentType.NECKLACE, BaubleType.AMULET);
        TREASURE_BAUBLE_TYPE_MAP.put(AdornmentType.BRACELET, BaubleType.BODY);
        TREASURE_BAUBLE_TYPE_MAP.put(AdornmentType.POCKET, BaubleType.BODY);
    }

    public static boolean isEnabled() {
        return TreasureConfig.INTEGRATION.enableBaubles && baublesLoaded;
    }

    public static boolean isBaubleEquipped(EntityPlayer player, Item item) {
        return BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)item) >= 0;
    }

    public static List<Adornment> getEquippedAdornments(EntityPlayer player) {
        ArrayList<Adornment> adornments = new ArrayList<Adornment>();
        BAUBLES_SLOTS.forEach(slot -> {
            ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot.intValue());
            if (stack.func_77973_b() instanceof Adornment) {
                adornments.add((Adornment)stack.func_77973_b());
            }
        });
        return adornments;
    }

    public static ItemStack getStackInSlot(EntityPlayer player, int slot) {
        return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
    }

    public static class BaubleAdornmentCapabilityProvider
    extends BaubleProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ICharmableCapability charmableCap;
        private final IRunestonesCapability runestonesCap;
        private final IDurabilityCapability durabilityCap;
        private AdornmentCapabilityProvider adornmentCapabilityProvider;

        public BaubleAdornmentCapabilityProvider(AdornmentType adornmentType) {
            super(adornmentType);
            this.charmableCap = new CharmableCapability(0, 0, 0);
            this.runestonesCap = new RunestonesCapability(0, 0, 0);
            this.durabilityCap = new DurabilityCapability();
            this.adornmentCapabilityProvider = new AdornmentCapabilityProvider(this.charmableCap, this.runestonesCap, this.durabilityCap);
        }

        public BaubleAdornmentCapabilityProvider(AdornmentType adornmentType, ICharmableCapability charmable) {
            super(adornmentType);
            this.charmableCap = charmable;
            this.runestonesCap = new RunestonesCapability(0, 0, 0);
            this.durabilityCap = new DurabilityCapability();
            this.adornmentCapabilityProvider = new AdornmentCapabilityProvider(this.charmableCap, this.runestonesCap, this.durabilityCap);
        }

        public BaubleAdornmentCapabilityProvider(AdornmentType adornmentType, ICharmableCapability charmable, IDurabilityCapability durability) {
            super(adornmentType);
            this.charmableCap = charmable;
            this.runestonesCap = new RunestonesCapability(0, 0, 0);
            this.durabilityCap = durability;
            this.adornmentCapabilityProvider = new AdornmentCapabilityProvider(this.charmableCap, this.runestonesCap, this.durabilityCap);
        }

        public BaubleAdornmentCapabilityProvider(AdornmentType adornmentType, ICharmableCapability charmable, IRunestonesCapability runestonesCapability, IDurabilityCapability durability) {
            super(adornmentType);
            this.charmableCap = charmable;
            this.runestonesCap = runestonesCapability;
            this.durabilityCap = durability;
            this.adornmentCapabilityProvider = new AdornmentCapabilityProvider(this.charmableCap, this.runestonesCap, this.durabilityCap);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE) {
                return true;
            }
            return this.adornmentCapabilityProvider.hasCapability(capability, facing);
        }

        @Override
        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE) {
                return (T)(this.hasCapability(capability, facing) ? itemStack -> this.type : null);
            }
            return this.adornmentCapabilityProvider.getCapability(capability, facing);
        }

        public NBTTagCompound serializeNBT() {
            return this.adornmentCapabilityProvider.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.adornmentCapabilityProvider.deserializeNBT(nbt);
        }
    }

    public static class BaubleProvider
    implements ICapabilityProvider {
        protected BaubleType type;

        public BaubleProvider(AdornmentType adornmntType) {
            this.type = TREASURE_BAUBLE_TYPE_MAP.get(adornmntType);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? itemStack -> this.type : null);
        }
    }
}

