/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CollapsingTrapPitGenerator
extends AbstractPitGenerator {
    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = super.generate(world, random, surfaceCoords, spawnCoords);
        if (result.isSuccess()) {
            Treasure.LOGGER.debug("Generated Collapsing Trap Pit at " + spawnCoords.toShortString());
        }
        return result;
    }

    @Override
    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        int minCoordsX = coords.getX() - 2;
        int maxCoordsX = coords.getX() + 2;
        int minCoordsZ = coords.getZ() - 2;
        int maxCoordsZ = coords.getZ() + 2;
        for (int x = minCoordsX; x <= maxCoordsX; ++x) {
            for (int z = minCoordsZ; z <= maxCoordsZ; ++z) {
                ICoords spawnCoords = WorldInfo.getSurfaceCoords((World)world, (ICoords)new Coords(x, 255, z));
                IBlockState state = world.func_180495_p((spawnCoords = spawnCoords.down(1)).toPos());
                if (state.func_177230_c() == Blocks.field_150349_c) {
                    if (x != minCoordsX && x != maxCoordsX || z != minCoordsZ && z != maxCoordsZ) {
                        GenUtil.replaceWithBlockState(world, spawnCoords, TreasureBlocks.FALLING_GRASS.func_176223_P());
                    }
                } else if (state.func_177230_c() == Blocks.field_150354_m) {
                    if (state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
                        GenUtil.replaceWithBlockState(world, spawnCoords, TreasureBlocks.FALLING_SAND.func_176223_P());
                    } else {
                        GenUtil.replaceWithBlockState(world, spawnCoords, TreasureBlocks.FALLING_RED_SAND.func_176223_P());
                    }
                }
                spawnCoords = spawnCoords.down(1);
                while (spawnCoords.getY() >= coords.getY()) {
                    GenUtil.replaceWithBlockState(world, spawnCoords, Blocks.field_150350_a.func_176223_P());
                    spawnCoords = spawnCoords.down(1);
                }
            }
        }
        return coords;
    }

    private ICoords build5WideLayer(World world, Random random, ICoords coords, Block block) {
        IBlockState blockState = block.func_176223_P();
        if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
            int meta = random.nextInt() % 2 == 0 ? 8 : 4;
            blockState = block.func_176203_a(meta);
        }
        GenUtil.replaceWithBlockState(world, coords, blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 0), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 0), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(0, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(0, 0, -1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, -1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, -1), blockState);
        for (int x = coords.getX() - 2; x <= coords.getX() + 2; ++x) {
            for (int z = coords.getZ() - 2; z <= coords.getZ() + 2; ++z) {
                GenUtil.replaceWithBlockState(world, coords.add(x, 0, z), blockState);
            }
        }
        return coords.add(0, 1, 0);
    }
}

