/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.marker;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplate;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.marker.GravestoneMarkerGenerator;
import com.someguyssoftware.treasure2.generator.marker.IMarkerGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.registry.TreasureTemplateRegistry;
import com.someguyssoftware.treasure2.tileentity.AbstractProximityTileEntity;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import com.someguyssoftware.treasure2.world.gen.structure.ITemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.DungeonHooks;

public class StructureMarkerGenerator
implements IMarkerGenerator<GeneratorResult<GeneratorData>> {
    @Override
    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords) {
        ResourceLocation r;
        Object te;
        ICoords c2;
        ICoords entranceCoords;
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        Biome biome = world.func_180494_b(coords.toPos());
        TemplateHolder holder = TreasureTemplateRegistry.getManager().getTemplate(world, random, StructureArchetype.SURFACE, StructureType.MARKER, biome);
        if (holder == null) {
            return result.fail();
        }
        int offset = 0;
        ICoords offsetCoords = ((GottschTemplate)holder.getTemplate()).findCoords(random, GenUtil.getMarkerBlock(StructureMarkers.OFFSET));
        if (offsetCoords != null) {
            offset = -offsetCoords.getY();
        }
        if ((entranceCoords = ((GottschTemplate)holder.getTemplate()).findCoords(random, GenUtil.getMarkerBlock(StructureMarkers.ENTRANCE))) == null) {
            Treasure.LOGGER.debug("Unable to locate entrance position.");
            return result.fail();
        }
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        Treasure.LOGGER.debug("above ground rotation used -> {}", (Object)rotation);
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotation).func_189950_a(random);
        Coords newEntrance = new Coords(GottschTemplate.func_186266_a((PlacementSettings)placement, (BlockPos)entranceCoords.toPos()));
        BlockPos transformedSize = holder.getTemplate().func_186257_a(rotation);
        ICoords spawnCoords = ITemplateGenerator.alignEntranceToCoords(coords, (ICoords)newEntrance, transformedSize, placement);
        if (offset >= -2 && !WorldInfo.isSolidBase((World)world, (ICoords)spawnCoords, (int)transformedSize.func_177958_n(), (int)transformedSize.func_177952_p(), (double)70.0)) {
            Treasure.LOGGER.debug("Coords -> [{}] does not meet {}% solid base requirements for size -> {} x {}", (Object)70, (Object)spawnCoords.toShortString(), (Object)transformedSize.func_177958_n(), (Object)transformedSize.func_177956_o());
            IGeneratorResult genResult = new GravestoneMarkerGenerator().generate(world, random, coords);
            return genResult;
        }
        GeneratorResult<TemplateGeneratorData> genResult = new TemplateGenerator().generate(world, random, holder, placement, spawnCoords);
        if (!genResult.isSuccess()) {
            return result.fail();
        }
        List spawnerContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.SPAWNER));
        List proximityContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.PROXIMITY_SPAWNER));
        for (BlockContext c : spawnerContexts) {
            c2 = spawnCoords.add(c.getCoords());
            world.func_175656_a(c2.toPos(), Blocks.field_150474_ac.func_176223_P());
            te = (TileEntityMobSpawner)world.func_175625_s(c2.toPos());
            r = DungeonHooks.getRandomDungeonMob((Random)random);
            te.func_145881_a().func_190894_a(r);
        }
        for (BlockContext c : proximityContexts) {
            c2 = spawnCoords.add(c.getCoords());
            world.func_175656_a(c2.toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
            te = (ProximitySpawnerTileEntity)world.func_175625_s(c2.toPos());
            r = DungeonHooks.getRandomDungeonMob((Random)random);
            ((ProximitySpawnerTileEntity)te).setMobName(r);
            ((ProximitySpawnerTileEntity)te).setMobNum(new Quantity(1.0, 2.0));
            ((AbstractProximityTileEntity)te).setProximity(10.0);
        }
        result.setData(genResult.getData());
        return result.success();
    }
}

