/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.chest;

import com.google.common.collect.Lists;
import com.someguyssoftware.gottschcore.loot.LootPoolShell;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.config.IChestConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.marker.GravestoneMarkerGenerator;
import com.someguyssoftware.treasure2.generator.marker.StructureMarkerGenerator;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

public interface IChestGenerator {
    default public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords coords, Rarity rarity, IBlockState state) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(coords);
        Optional<LootTableShell> lootTableShell = this.selectLootTable2(random, rarity);
        ResourceLocation lootTableResourceLocation = null;
        if (!lootTableShell.isPresent()) {
            Treasure.LOGGER.debug("Unable to select a LootTable for rarity -> {}", (Object)rarity);
            return result.fail();
        }
        lootTableResourceLocation = lootTableShell.get().getResourceLocation();
        AbstractChestBlock chest = this.selectChest(random, rarity);
        if (chest == null) {
            Treasure.LOGGER.warn("Unable to select a chest for rarity -> {}.", (Object)rarity);
            return result.fail();
        }
        TileEntity tileEntity = null;
        tileEntity = state != null ? this.placeInWorld(world, random, coords, chest, state) : this.placeInWorld(world, random, chest, coords);
        if (tileEntity == null) {
            Treasure.LOGGER.debug("Unable to locate tile entity for chest -> {}", (Object)coords);
            return result.fail();
        }
        this.addLootTable((AbstractTreasureChestTileEntity)tileEntity, lootTableResourceLocation);
        this.addSeal((AbstractTreasureChestTileEntity)tileEntity);
        this.addGenerationContext((AbstractTreasureChestTileEntity)tileEntity, rarity);
        this.addLocks(random, chest, (AbstractTreasureChestTileEntity)tileEntity, rarity);
        result.getData().setChestContext(new BlockContext(coords, state));
        return result.success();
    }

    default public boolean isChestEnabled(Block chest) {
        return chest instanceof TreasureChestBlock && (!TreasureConfig.CHESTS.chestEnablementMap.containsKey(chest.getRegistryName().func_110623_a()) || TreasureConfig.CHESTS.chestEnablementMap.get(chest.getRegistryName().func_110623_a()) != false);
    }

    default public List<LootTableShell> buildLootTableList2(Rarity rarity) {
        return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(TreasureLootTableMaster2.ManagedTableType.CHEST, rarity);
    }

    default public Optional<List<LootTableShell>> buildInjectedLootTableList(String key, Rarity rarity) {
        return Optional.ofNullable(TreasureLootTableRegistry.getLootTableMaster().getLootTableByKeyRarity(TreasureLootTableMaster2.ManagedTableType.INJECT, key, rarity));
    }

    default public AbstractChestBlock selectChest(Random random, Rarity rarity) {
        List chestList = (List)TreasureBlocks.chests.get((Object)rarity);
        if (chestList == null || chestList.isEmpty()) {
            return null;
        }
        AbstractChestBlock chest = (AbstractChestBlock)chestList.get(RandomHelper.randomInt((Random)random, (int)0, (int)(chestList.size() - 1)));
        IChestConfig config = TreasureConfig.CHESTS.surfaceChests.configMap.get((Object)rarity);
        if (chest == TreasureBlocks.WOOD_CHEST) {
            if (RandomHelper.checkProbability((Random)random, (double)config.getMimicProbability())) {
                chest = (AbstractChestBlock)TreasureBlocks.WOOD_MIMIC;
                Treasure.LOGGER.debug("Selecting a WOOD MIMIC chest!");
            }
        } else if (chest == TreasureBlocks.PIRATE_CHEST && RandomHelper.checkProbability((Random)random, (double)config.getMimicProbability())) {
            chest = (AbstractChestBlock)TreasureBlocks.PIRATE_MIMIC;
            Treasure.LOGGER.debug("Selecting a PIRATE MIMIC chest!");
        }
        return chest;
    }

    default public void fillChest(World world, Random random, TileEntity tileEntity, Rarity rarity, EntityPlayer player) {
        Optional<LootTableShell> lootTableShell = null;
        ResourceLocation lootTableResourceLocation = ((AbstractTreasureChestTileEntity)tileEntity).getLootTable();
        Treasure.LOGGER.debug("chest has loot table property of -> {}", (Object)lootTableResourceLocation);
        lootTableShell = lootTableResourceLocation == null ? this.selectLootTable2(random, rarity) : TreasureLootTableRegistry.getLootTableMaster().getLootTableByResourceLocation(lootTableResourceLocation);
        if (!lootTableShell.isPresent()) {
            Treasure.LOGGER.debug("Unable to select a LootTable for rarity -> {}", (Object)rarity);
            return;
        }
        Treasure.LOGGER.debug("using loot table shell -> {}, {}", (Object)lootTableShell.get().getCategory(), (Object)lootTableShell.get().getRarity());
        lootTableResourceLocation = lootTableShell.get().getResourceLocation();
        Treasure.LOGGER.debug("loot table resource -> {}", (Object)lootTableResourceLocation);
        LootTable lootTable = world.func_184146_ak().func_186521_a(lootTableResourceLocation);
        if (lootTable == null) {
            Treasure.LOGGER.warn("Unable to select a lootTable.");
            return;
        }
        Treasure.LOGGER.debug("selected loot table -> {} from resource -> {}", (Object)lootTable, (Object)lootTableResourceLocation);
        Rarity effectiveRarity = TreasureLootTableRegistry.getLootTableMaster().getEffectiveRarity(lootTableShell.get(), rarity);
        Treasure.LOGGER.debug("Generating loot from loot table for effective rarity {}", (Object)effectiveRarity);
        ArrayList<ItemStack> treasureStacks = new ArrayList<ItemStack>();
        ArrayList itemStacks = new ArrayList();
        List lootPoolShells = lootTableShell.get().getPools();
        if (lootPoolShells != null && lootPoolShells.size() > 0) {
            Treasure.LOGGER.debug("# of pools -> {}", (Object)lootPoolShells.size());
        }
        LootContext lootContext = null;
        lootContext = player == null ? TreasureLootTableRegistry.getLootTableMaster().getContext() : new LootContext.Builder((WorldServer)world).func_186469_a(player.func_184817_da()).func_186470_a(player).func_186471_a();
        for (LootPoolShell pool : lootPoolShells) {
            Treasure.LOGGER.debug("processing pool -> {}", (Object)pool.getName());
            LootPool lootPool = lootTable.getPool(pool.getName());
            if (pool.getName().equalsIgnoreCase("treasure") || pool.getName().equalsIgnoreCase("charms")) {
                Treasure.LOGGER.debug("processing 'treasure|charm' pool -> {}", (Object)pool.getName());
                lootPool.func_186449_b(treasureStacks, random, lootContext);
                continue;
            }
            lootPool.func_186449_b(itemStacks, random, lootContext);
        }
        Treasure.LOGGER.debug("size of treasure stacks -> {}", (Object)treasureStacks.size());
        Treasure.LOGGER.debug("size of item stacks -> {}", (Object)itemStacks.size());
        int lootItemSize = itemStacks.size();
        Treasure.LOGGER.debug("searching for injectable tables for category ->{}, rarity -> {}", (Object)lootTableShell.get().getCategory(), (Object)effectiveRarity);
        Optional<List<LootTableShell>> injectLootTableShells = this.buildInjectedLootTableList(lootTableShell.get().getCategory(), effectiveRarity);
        if (injectLootTableShells.isPresent()) {
            Treasure.LOGGER.debug("found injectable tables for category ->{}, rarity -> {}", (Object)lootTableShell.get().getCategory(), (Object)effectiveRarity);
            Treasure.LOGGER.debug("size of injectable tables -> {}", (Object)injectLootTableShells.get().size());
            itemStacks.addAll(TreasureLootTableRegistry.getLootTableMaster().getInjectedLootItems(world, random, injectLootTableShells.get(), lootContext));
        }
        this.fillInventory((IInventory)tileEntity, random, treasureStacks);
        Collections.shuffle(itemStacks, random);
        this.fillInventory((IInventory)tileEntity, random, itemStacks.stream().limit(lootItemSize).collect(Collectors.toList()));
    }

    default public void fillInventory(IInventory inventory, Random random, List<ItemStack> list) {
        List<Integer> emptySlots = this.getEmptySlotsRandomized(inventory, random);
        Treasure.LOGGER.debug("beginning empty slots size -> {}", (Object)emptySlots.size());
        this.shuffleItems(list, emptySlots.size(), random);
        for (ItemStack itemstack : list) {
            if (emptySlots.isEmpty()) {
                return;
            }
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(emptySlots.remove(emptySlots.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(emptySlots.remove(emptySlots.size() - 1).intValue(), itemstack);
        }
        Treasure.LOGGER.debug("ending empty slots size -> {}", (Object)emptySlots.size());
    }

    default public List<Integer> getEmptySlotsRandomized(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    default public void shuffleItems(List<ItemStack> stacks, int emptySlotsSize, Random rand) {
        Collections.shuffle(stacks, rand);
    }

    default public Optional<LootTableShell> selectLootTable2(Random random, Rarity rarity) {
        LootTableShell lootTableShell = null;
        List<LootTableShell> tables = this.buildLootTableList2(rarity);
        if (tables != null) {
            Treasure.LOGGER.debug("tables size -> {}", (Object)tables.size());
        }
        if (tables != null && !tables.isEmpty()) {
            int index = 0;
            if (tables.size() == 1) {
                lootTableShell = tables.get(0);
            } else {
                index = RandomHelper.randomInt((Random)random, (int)0, (int)(tables.size() - 1));
                lootTableShell = tables.get(index);
            }
            Treasure.LOGGER.debug("Selected loot table shell index --> {}", (Object)index);
        }
        return Optional.ofNullable(lootTableShell);
    }

    default public Optional<LootTableShell> selectLootTable2(Supplier<Random> factory, Rarity rarity) {
        LootTableShell lootTableShell = null;
        List<LootTableShell> tables = this.buildLootTableList2(rarity);
        if (tables != null) {
            Treasure.LOGGER.debug("tables size -> {}", (Object)tables.size());
        }
        if (tables != null && !tables.isEmpty()) {
            int index = 0;
            if (tables.size() == 1) {
                lootTableShell = tables.get(0);
            } else {
                index = RandomHelper.randomInt((Random)factory.get(), (int)0, (int)(tables.size() - 1));
                lootTableShell = tables.get(index);
            }
            Treasure.LOGGER.debug("Selected loot table shell index --> {}", (Object)index);
        }
        return Optional.ofNullable(lootTableShell);
    }

    public void addGenerationContext(AbstractTreasureChestTileEntity var1, Rarity var2);

    default public void addLootTable(AbstractTreasureChestTileEntity tileEntity, ResourceLocation location) {
        tileEntity.setLootTable(location);
    }

    default public void addSeal(AbstractTreasureChestTileEntity tileEntity) {
        tileEntity.setSealed(true);
    }

    default public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity chestTileEntity, Rarity rarity) {
        ArrayList<LockItem> locks = new ArrayList<LockItem>();
        locks.addAll(TreasureItems.locks.get((Object)rarity));
        this.addLocks(random, chest, chestTileEntity, locks);
        locks.clear();
    }

    default public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity chestTileEntity, List<LockItem> locks) {
        int numLocks = this.randomizedNumberOfLocksByChestType(random, chest.getChestType());
        List<LockState> lockStates = chestTileEntity.getLockStates();
        for (int i = 0; i < numLocks; ++i) {
            LockItem lock = locks.get(RandomHelper.randomInt((Random)random, (int)0, (int)(locks.size() - 1)));
            Treasure.LOGGER.debug("adding lock: {}", (Object)lock);
            lockStates.get(i).setLock(lock);
        }
    }

    default public int randomizedNumberOfLocksByChestType(Random random, TreasureChestType type) {
        int numLocks = RandomHelper.randomInt((Random)random, (int)0, (int)type.getMaxLocks());
        Treasure.LOGGER.debug("# of locks to use: {})", (Object)numLocks);
        return numLocks;
    }

    default public void addMarkers(World world, Random random, ICoords coords, boolean isSurfaceChest) {
        if (!isSurfaceChest && TreasureConfig.WORLD_GEN.getMarkerProperties().isMarkerStructuresAllowed && RandomHelper.checkProbability((Random)random, (int)TreasureConfig.WORLD_GEN.getMarkerProperties().markerStructureProbability)) {
            Treasure.LOGGER.debug("generating a random structure marker -> {}", (Object)coords.toShortString());
            new StructureMarkerGenerator().generate(world, random, coords);
        } else {
            new GravestoneMarkerGenerator().generate(world, random, coords);
        }
    }

    default public TileEntity placeInWorld(World world, Random random, AbstractChestBlock chest, ICoords chestCoords) {
        boolean isPlaced = GenUtil.replaceBlockWithChest(world, random, (Block)chest, chestCoords);
        TileEntity tileEntity = world.func_175625_s(chestCoords.toPos());
        if (!isPlaced || !(world.func_180495_p(chestCoords.toPos()).func_177230_c() instanceof AbstractChestBlock)) {
            Treasure.LOGGER.debug("Unable to place chest @ {}", (Object)chestCoords.toShortString());
            if (tileEntity != null && tileEntity instanceof AbstractTreasureChestTileEntity) {
                world.func_175713_t(chestCoords.toPos());
            }
            return null;
        }
        if (tileEntity == null || !(tileEntity instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.LOGGER.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return tileEntity;
    }

    default public TileEntity placeInWorld(World world, Random random, ICoords chestCoords, AbstractChestBlock chest, IBlockState state) {
        boolean isPlaced = GenUtil.replaceBlockWithChest(world, random, chestCoords, (Block)chest, state);
        Treasure.LOGGER.debug("isPlaced -> {}", (Object)isPlaced);
        TileEntity tileEntity = world.func_175625_s(chestCoords.toPos());
        if (!isPlaced || !(world.func_180495_p(chestCoords.toPos()).func_177230_c() instanceof AbstractChestBlock)) {
            Treasure.LOGGER.debug("Unable to place chest @ {}", (Object)chestCoords.toShortString());
            if (tileEntity != null && tileEntity instanceof AbstractTreasureChestTileEntity) {
                world.func_175713_t(chestCoords.toPos());
            }
            return null;
        }
        if (tileEntity == null || !(tileEntity instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.LOGGER.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return tileEntity;
    }
}

