/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AnvilEventHandler {
    private IMod mod;

    public AnvilEventHandler(IMod mod) {
        this.setMod(mod);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack leftStack = event.getLeft();
        ItemStack rightStack = event.getRight();
        if (leftStack.func_77973_b() == rightStack.func_77973_b() && leftStack.func_77973_b() instanceof KeyItem) {
            if (leftStack.hasCapability(TreasureCapabilities.DURABILITY, null) && rightStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
                event.setCost(1);
                DurabilityCapability leftItemCap = (DurabilityCapability)leftStack.getCapability(TreasureCapabilities.DURABILITY, null);
                DurabilityCapability rightItemCap = (DurabilityCapability)rightStack.getCapability(TreasureCapabilities.DURABILITY, null);
                if (leftItemCap != null && rightItemCap != null) {
                    int leftRemainingUses = leftItemCap.getDurability() - leftStack.func_77952_i();
                    int rightRemainingUses = rightItemCap.getDurability() - rightStack.func_77952_i();
                    ItemStack outputItem = new ItemStack(leftStack.func_77973_b());
                    DurabilityCapability outputItemCap = (DurabilityCapability)outputItem.getCapability(TreasureCapabilities.DURABILITY, null);
                    int remainingUses = leftRemainingUses + rightRemainingUses;
                    if (remainingUses > Math.max(leftItemCap.getDurability(), rightItemCap.getDurability())) {
                        outputItemCap.setDurability(Math.max(leftItemCap.getDurability(), rightItemCap.getDurability()) + leftStack.func_77958_k());
                        outputItem.func_77964_b(leftStack.func_77952_i() + rightStack.func_77952_i());
                    } else {
                        if (remainingUses < Math.min(leftItemCap.getDurability(), rightItemCap.getDurability())) {
                            outputItemCap.setDurability(Math.min(leftItemCap.getDurability(), rightItemCap.getDurability()));
                        } else {
                            outputItemCap.setDurability(Math.max(leftItemCap.getDurability(), rightItemCap.getDurability()));
                        }
                        outputItem.func_77964_b(outputItemCap.getDurability() - remainingUses);
                    }
                    event.setOutput(outputItem);
                }
            }
        } else if (leftStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && rightStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)leftStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isSocketable() && ((ICharmableCapability)rightStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isBindable()) {
            event.setCost(2);
            ((IRunestonesCapability)leftStack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.INNATE).forEach(entity -> Treasure.LOGGER.debug("binding charm: sourceStack.appliedTo -> {}", entity.getAppliedTo()));
            Optional<ItemStack> outStack = AnvilEventHandler.transferCapabilities(rightStack, leftStack, InventoryType.INNATE, InventoryType.SOCKET);
            if (outStack.isPresent()) {
                if (outStack.get().hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                    ((IRunestonesCapability)outStack.get().getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(entity -> {
                        Treasure.LOGGER.debug("binding charm: is applied -> {}", (Object)entity.isApplied());
                        Treasure.LOGGER.debug("binding charm: applied to -> {}", entity.getAppliedTo());
                        Treasure.LOGGER.debug("binding charm: applying runestone -> {} to entity -> {}", (Object)entity.getRunestone(), entity);
                        entity.getRunestone().apply((ItemStack)outStack.get(), (IRuneEntity)entity);
                        Treasure.LOGGER.debug("binding charm: after apply: is applied -> {}", (Object)entity.isApplied());
                        Treasure.LOGGER.debug("binding charm: after apply: applied to -> {}", entity.getAppliedTo());
                        ((ICharmableCapability)((ItemStack)outStack.get()).getCapability(TreasureCapabilities.CHARMABLE, null)).getCharmEntities().forEach((type2, charm) -> Treasure.LOGGER.debug("binding charm: entity -> {}, mana -> {}, max mana -> {}", (Object)charm.getCharm().getName().toString(), (Object)charm.getMana(), (Object)charm.getMaxMana()));
                    });
                }
                event.setOutput(outStack.get());
            }
        } else if (leftStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)leftStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isImbuable() && rightStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)rightStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isImbuing()) {
            event.setCost(2);
            Optional<ItemStack> outStack = AnvilEventHandler.transferCapabilities(rightStack, leftStack, InventoryType.INNATE, InventoryType.IMBUE);
            if (outStack.isPresent()) {
                if (outStack.get().hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                    ((IRunestonesCapability)outStack.get().getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.IMBUE).forEach(entity -> entity.getRunestone().apply((ItemStack)outStack.get(), (IRuneEntity)entity));
                }
                event.setOutput(outStack.get());
            }
        } else if (leftStack.hasCapability(TreasureCapabilities.RUNESTONES, null) && rightStack.hasCapability(TreasureCapabilities.RUNESTONES, null) && ((IRunestonesCapability)leftStack.getCapability(TreasureCapabilities.RUNESTONES, null)).isSocketable() && ((IRunestonesCapability)rightStack.getCapability(TreasureCapabilities.RUNESTONES, null)).isBindable()) {
            event.setCost(2);
            ((IRunestonesCapability)rightStack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.INNATE).forEach(entity -> Treasure.LOGGER.debug("rightStack.appliedTo -> {}", entity.getAppliedTo()));
            Optional<ItemStack> stack = AnvilEventHandler.transferCapabilities(rightStack, leftStack, InventoryType.INNATE, InventoryType.SOCKET);
            if (stack.isPresent()) {
                AtomicBoolean isStackValid = new AtomicBoolean(true);
                ((IRunestonesCapability)stack.get().getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(entity -> {
                    Treasure.LOGGER.debug("is applied -> {}", (Object)entity.isApplied());
                    Treasure.LOGGER.debug("applied to -> {}", entity.getAppliedTo());
                    Treasure.LOGGER.debug("applying runestone -> {} to entity -> {}", (Object)entity.getRunestone(), entity);
                    Treasure.LOGGER.debug("applying cap...");
                    if (!entity.getRunestone().isValid((ItemStack)stack.get())) {
                        isStackValid.set(false);
                        return;
                    }
                    entity.getRunestone().apply((ItemStack)stack.get(), (IRuneEntity)entity);
                    ((ICharmableCapability)((ItemStack)stack.get()).getCapability(TreasureCapabilities.CHARMABLE, null)).getCharmEntities().forEach((type, charm) -> Treasure.LOGGER.debug("entity -> {}, mana -> {}, max mana -> {}, costEval -> {}", (Object)charm.getCharm().getName().toString(), (Object)charm.getMana(), (Object)charm.getMaxMana(), (Object)charm.getCostEvaluator().getClass().getSimpleName()));
                    ((IRunestonesCapability)((ItemStack)stack.get()).getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(stone -> Treasure.LOGGER.debug("output runestone -> {}", stone));
                });
                if (isStackValid.get()) {
                    event.setOutput(stack.get());
                }
            }
        } else if (leftStack.func_77973_b() instanceof Adornment && leftStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && TreasureCharmableMaterials.isSourceItemRegistered(rightStack.func_77973_b().getRegistryName())) {
            ICharmableCapability cap = (ICharmableCapability)leftStack.getCapability(TreasureCapabilities.CHARMABLE, null);
            if (cap.getSourceItem().equals((Object)Items.field_190931_a.getRegistryName())) {
                event.setCost(1);
                event.setMaterialCost(1);
                Optional<Adornment> adornment = AnvilEventHandler.getAdornment(leftStack, rightStack);
                Treasure.LOGGER.debug("adornment -> {}", (Object)adornment.get().getRegistryName());
                if (adornment.isPresent()) {
                    ItemStack outputStack = AnvilEventHandler.copyStack(leftStack, new ItemStack((Item)adornment.get()));
                    ICharmableCapability outputCap = (ICharmableCapability)outputStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                    outputCap.setHighestLevel(cap.getHighestLevel());
                    event.setOutput(outputStack);
                }
            }
        } else if (leftStack.func_77973_b() instanceof Adornment && rightStack.func_77973_b() instanceof Adornment) {
            event.setCost(1);
            event.setMaterialCost(1);
            Treasure.LOGGER.debug("both are adornments");
            IDurabilityCapability leftcap = (IDurabilityCapability)leftStack.getCapability(TreasureCapabilities.DURABILITY, null);
            Treasure.LOGGER.debug("leftStack current durability-> {}, max -> {}", (Object)(leftcap.getDurability() - leftStack.func_77952_i()), (Object)leftcap.getMaxDurability());
            ItemStack outputStack = AnvilEventHandler.copyStack(leftStack, new ItemStack(leftStack.func_77973_b()));
            IDurabilityCapability cap = (IDurabilityCapability)outputStack.getCapability(TreasureCapabilities.DURABILITY, null);
            if (cap.getRepairs() > 0 && outputStack.func_77952_i() > 0) {
                outputStack.func_77964_b(0);
                cap.setRepairs(cap.getRepairs() - 1);
                event.setOutput(outputStack);
                Treasure.LOGGER.debug("repairs -> {}, max repairs -> {}", (Object)cap.getRepairs(), (Object)cap.getMaxRepairs());
                Treasure.LOGGER.debug("current durability-> {}, max -> {}", (Object)(cap.getDurability() - outputStack.func_77952_i()), (Object)cap.getMaxDurability());
            }
        }
    }

    @Deprecated
    public static Optional<ItemStack> transferCapabilities(ItemStack source, ItemStack dest, InventoryType sourceType, InventoryType destType) {
        Treasure.LOGGER.debug("transfering caps...");
        ItemStack stack = new ItemStack(dest.func_77973_b());
        if (dest.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            ((IDurabilityCapability)dest.getCapability(TreasureCapabilities.DURABILITY, null)).copyTo(stack);
        }
        boolean charmSizeChanged = false;
        boolean runeSizeChanged = false;
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ((ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null)).clearCharms();
            ((ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null)).copyTo(stack);
            if (source.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
                ((ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null)).transferTo(stack, sourceType, destType);
                if (((ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null)).getCurrentSize(destType) > ((ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null)).getCurrentSize(destType)) {
                    charmSizeChanged = true;
                }
            }
        }
        if (dest.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            ((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).clear();
            Treasure.LOGGER.debug("before copyTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
            ((IRunestonesCapability)dest.getCapability(TreasureCapabilities.RUNESTONES, null)).copyTo(stack);
            Treasure.LOGGER.debug("after copyTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
            if (source.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                Treasure.LOGGER.debug("source(runestone)'s runes ->");
                ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.INNATE).forEach(entity -> Treasure.LOGGER.debug("source entity -> {}", entity));
                ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).transferTo(stack, sourceType, destType);
                Treasure.LOGGER.debug("after transferTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
                if (((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getCurrentSize(destType) > ((IRunestonesCapability)dest.getCapability(TreasureCapabilities.RUNESTONES, null)).getCurrentSize(destType)) {
                    runeSizeChanged = true;
                }
            }
        }
        if (charmSizeChanged | runeSizeChanged) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    @Deprecated
    private static Optional<Adornment> getAdornment(ItemStack baseStack, ItemStack stoneStack) {
        if (baseStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && baseStack.func_77973_b() instanceof Adornment) {
            ICharmableCapability cap = (ICharmableCapability)baseStack.getCapability(TreasureCapabilities.CHARMABLE, null);
            Adornment sourceAdornment = (Adornment)baseStack.func_77973_b();
            return TreasureAdornmentRegistry.get(sourceAdornment.getType(), sourceAdornment.getSize(), cap.getBaseMaterial(), stoneStack.func_77973_b().getRegistryName());
        }
        return Optional.empty();
    }

    @Deprecated
    private static ItemStack copyStack(ItemStack source, ItemStack dest) {
        ItemStack resultStack = dest.func_77946_l();
        ResourceLocation sourceItem = ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem();
        resultStack.func_77964_b(source.func_77952_i());
        if (resultStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            Treasure.LOGGER.debug("calling durability copyTo()");
            ((IDurabilityCapability)source.getCapability(TreasureCapabilities.DURABILITY, null)).copyTo(resultStack);
        }
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).clearCharms();
            ((ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null)).copyTo(resultStack);
        }
        if (dest.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            ((IRunestonesCapability)resultStack.getCapability(TreasureCapabilities.RUNESTONES, null)).clear();
            ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).copyTo(resultStack);
        }
        ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).setSourceItem(sourceItem);
        return resultStack;
    }

    public boolean doKeyMerge() {
        return true;
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }
}

