/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGeneratorType;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.registry.TreasureDecayRegistry;
import com.someguyssoftware.treasure2.registry.TreasureTemplateRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnRuinsCommand
extends CommandBase {
    private static final String MOD_ID_ARG = "modid";
    private static final String ARCHETYPE_ARG = "archetype";
    private static final String NAME_ARG = "name";
    private static final String RULESET_ARG = "ruleset";
    private static final String RARITY_ARG = "rarity";

    public String func_71517_b() {
        return "t2-ruins";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-ruins <x> <y> <z> [-modid <mod id> -archetype <archetype> -name <name>] [-ruleset <relative filepath>] [-rarity <rarity>]: spawns ruins at location (x, y, z)";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.LOGGER.debug("Starting to build Treasure! ruins ...");
        try {
            String name;
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(MOD_ID_ARG, true, "");
            options.addOption(ARCHETYPE_ARG, true, "");
            options.addOption(NAME_ARG, true, "");
            options.addOption(RULESET_ARG, true, "");
            options.addOption(RARITY_ARG, true, "");
            CommandLine line = parser.parse(options, parserArgs);
            String modID = "treasure2";
            if (line.hasOption(MOD_ID_ARG)) {
                modID = line.getOptionValue(MOD_ID_ARG);
            }
            String archetype = StructureArchetype.SURFACE.getValue();
            if (line.hasOption(ARCHETYPE_ARG)) {
                archetype = line.getOptionValue(ARCHETYPE_ARG).toLowerCase();
            }
            if ((name = line.getOptionValue(NAME_ARG)) != null && !name.contains(".nbt")) {
                name = name + ".nbt";
            }
            IDecayRuleSet ruleSet = null;
            if (line.hasOption(RULESET_ARG)) {
                String ruleSetName = line.getOptionValue(RULESET_ARG);
                if (!ruleSetName.contains(".json")) {
                    ruleSetName = ruleSetName + ".json";
                }
                String key = ("treasure2:decay/" + ruleSetName).replace("\\", "/");
                ruleSet = TreasureDecayRegistry.getManager().getRuleSetMap().get(key);
            }
            Rarity rarity = null;
            if (line.hasOption(RARITY_ARG)) {
                String rarityArg = line.getOptionValue(RARITY_ARG);
                rarity = Rarity.valueOf(rarityArg.toUpperCase());
            }
            World world = commandSender.func_130014_f_();
            Random random = new Random();
            Coords coords = new Coords(x, y, z);
            SurfaceChestWorldGenerator worldGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGeneratorType.SURFACE_CHEST);
            ResourceLocation templateKey = new ResourceLocation("treasure2:" + TreasureTemplateRegistry.getManager().getBaseResourceFolder() + "/" + modID + "/" + archetype + "/" + name);
            TemplateHolder holder = TreasureTemplateRegistry.getManager().getTemplatesByResourceLocationMap().get(templateKey);
            if (holder == null) {
                Treasure.LOGGER.debug("Unable to locate template by key -> {}", (Object)templateKey.toString());
            }
            if (rarity == null) {
                rarity = Rarity.values()[random.nextInt(Rarity.values().length)];
            }
            GeneratorResult<ChestGeneratorData> result = worldGen.generateSurfaceRuins(world, random, (ICoords)coords, holder, ruleSet, null);
            Treasure.LOGGER.debug("result from t2-ruins -> {}", result);
            if (result.isSuccess() && result.getData().getChestContext().getCoords() != null) {
                IChestGenerator chestGen = (IChestGenerator)worldGen.getChestGenMap().get((Object)rarity).next();
                ICoords chestCoords = result.getData().getChestContext().getCoords();
                Treasure.LOGGER.debug("chestCoords -> {}", (Object)chestCoords);
                if (chestCoords == WorldInfo.EMPTY_COORDS) {
                    chestCoords = null;
                }
                if (chestCoords != null) {
                    GeneratorResult<ChestGeneratorData> generatorResult = chestGen.generate(world, random, chestCoords, rarity, result.getData().getChestContext().getState());
                }
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error generating Treasure! ruins:", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 3) {
            if (args[args.length - 2].equals("-rarity")) {
                return SpawnRuinsCommand.func_175762_a((String[])args, Rarity.getNames());
            }
            if (args[args.length - 2].equals("-archetype")) {
                return SpawnRuinsCommand.func_175762_a((String[])args, StructureArchetype.getNames());
            }
        }
        return Collections.emptyList();
    }
}

