/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.client.gui;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.client.gui.inventory.CharmingTableGui;
import com.someguyssoftware.treasure2.client.gui.inventory.CompressorChestGui;
import com.someguyssoftware.treasure2.client.gui.inventory.JewelerBenchGui;
import com.someguyssoftware.treasure2.client.gui.inventory.KeyRingGui;
import com.someguyssoftware.treasure2.client.gui.inventory.PouchGui;
import com.someguyssoftware.treasure2.client.gui.inventory.SkullChestGui;
import com.someguyssoftware.treasure2.client.gui.inventory.StandardChestGui;
import com.someguyssoftware.treasure2.client.gui.inventory.StrongboxChestGui;
import com.someguyssoftware.treasure2.client.gui.inventory.WitherChestGui;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.inventory.CharmingTableContainer;
import com.someguyssoftware.treasure2.inventory.CompressorChestContainer;
import com.someguyssoftware.treasure2.inventory.JewelerBenchContainer;
import com.someguyssoftware.treasure2.inventory.KeyRingContainer;
import com.someguyssoftware.treasure2.inventory.KeyRingInventory;
import com.someguyssoftware.treasure2.inventory.PouchContainer;
import com.someguyssoftware.treasure2.inventory.PouchInventory;
import com.someguyssoftware.treasure2.inventory.SkullChestContainer;
import com.someguyssoftware.treasure2.inventory.StandardChestContainer;
import com.someguyssoftware.treasure2.inventory.StrongboxChestContainer;
import com.someguyssoftware.treasure2.inventory.WitherChestContainer;
import com.someguyssoftware.treasure2.item.KeyRingItem;
import com.someguyssoftware.treasure2.item.PouchItem;
import com.someguyssoftware.treasure2.tileentity.ITreasureChestTileEntity;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public static final int STANDARD_CHEST_GUIID = 1;
    public static final int STRONGBOX_CHEST_GUIID = 2;
    public static final int KEY_RING_GUIID = 3;
    public static final int COMPRESSOR_CHEST_GUIID = 4;
    public static final int SKULL_CHEST_GUIID = 5;
    public static final int ARMOIRE_GUID = 6;
    public static final int WITHER_CHEST_GUIID = 7;
    public static final int POUCH_GUIID = 50;
    public static final int JEWELER_BENCH = 51;
    public static final int CHARMING_BENCH = 52;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof ITreasureChestTileEntity) {
            ITreasureChestTileEntity chestTileEntity = (ITreasureChestTileEntity)tileEntity;
            Treasure.LOGGER.debug("is chest sealed -> {}", (Object)chestTileEntity.isSealed());
            if (chestTileEntity.isSealed()) {
                chestTileEntity.setSealed(false);
                Treasure.LOGGER.debug("chest gen type -> {}", (Object)chestTileEntity.getGenerationContext().getChestGeneratorType());
                IChestGenerator chestGenerator = chestTileEntity.getGenerationContext().getChestGeneratorType().getChestGenerator();
                Treasure.LOGGER.debug("chest gen  -> {}", (Object)chestTileEntity.getGenerationContext().getChestGeneratorType().getChestGenerator().getClass().getSimpleName());
                chestGenerator.fillChest(world, new Random(), tileEntity, chestTileEntity.getGenerationContext().getLootRarity(), player);
            }
        }
        Container container = null;
        switch (ID) {
            case 1: {
                container = new StandardChestContainer(player.field_71071_by, (IInventory)tileEntity);
                break;
            }
            case 2: {
                container = new StrongboxChestContainer(player.field_71071_by, (IInventory)tileEntity);
                break;
            }
            case 4: {
                container = new CompressorChestContainer(player.field_71071_by, (IInventory)tileEntity);
                break;
            }
            case 5: {
                container = new SkullChestContainer(player.field_71071_by, (IInventory)tileEntity);
                break;
            }
            case 7: {
                container = new WitherChestContainer(player.field_71071_by, (IInventory)tileEntity);
                break;
            }
            case 3: {
                ItemStack keyRingItem = player.func_184614_ca();
                if (!(keyRingItem != null && keyRingItem.func_77973_b() instanceof KeyRingItem || (keyRingItem = player.func_184592_cb()) != null && keyRingItem.func_77973_b() instanceof KeyRingItem)) {
                    return null;
                }
                KeyRingInventory inventory = new KeyRingInventory(keyRingItem);
                container = new KeyRingContainer(player.field_71071_by, inventory);
                break;
            }
            case 50: {
                ItemStack pouchStack = player.func_184614_ca();
                if (!(pouchStack != null && pouchStack.func_77973_b() instanceof PouchItem || (pouchStack = player.func_184592_cb()) != null && pouchStack.func_77973_b() instanceof PouchItem)) {
                    return null;
                }
                PouchInventory pouchInventory = new PouchInventory(pouchStack);
                container = new PouchContainer(player.field_71071_by, pouchInventory, pouchStack);
                break;
            }
            case 51: {
                Treasure.LOGGER.debug("creating jeweler bench container server-side");
                container = new JewelerBenchContainer(player.field_71071_by, world, new BlockPos(x, y, z), player);
                break;
            }
            case 52: {
                Treasure.LOGGER.debug("creating charming bench container server-side");
                container = new CharmingTableContainer(player.field_71071_by, world, new BlockPos(x, y, z), player);
                break;
            }
        }
        return container;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        ITreasureChestTileEntity chestTileEntity = null;
        switch (ID) {
            case 1: {
                chestTileEntity = this.getChestTileEntity(tileEntity);
                if (chestTileEntity == null) {
                    return null;
                }
                return new StandardChestGui(player.field_71071_by, chestTileEntity);
            }
            case 2: {
                chestTileEntity = this.getChestTileEntity(tileEntity);
                if (chestTileEntity == null) {
                    return null;
                }
                return new StrongboxChestGui(player.field_71071_by, chestTileEntity);
            }
            case 4: {
                chestTileEntity = this.getChestTileEntity(tileEntity);
                if (chestTileEntity == null) {
                    return null;
                }
                return new CompressorChestGui(player.field_71071_by, chestTileEntity);
            }
            case 5: {
                chestTileEntity = this.getChestTileEntity(tileEntity);
                if (chestTileEntity == null) {
                    return null;
                }
                return new SkullChestGui(player.field_71071_by, chestTileEntity);
            }
            case 7: {
                chestTileEntity = this.getChestTileEntity(tileEntity);
                if (chestTileEntity == null) {
                    return null;
                }
                return new WitherChestGui(player.field_71071_by, chestTileEntity);
            }
            case 3: {
                ItemStack keyRingItem = player.func_184614_ca();
                if (!(keyRingItem != null && keyRingItem.func_77973_b() instanceof KeyRingItem || (keyRingItem = player.func_184592_cb()) != null && keyRingItem.func_77973_b() instanceof KeyRingItem)) {
                    return null;
                }
                KeyRingInventory inventory = new KeyRingInventory(keyRingItem);
                return new KeyRingGui(player.field_71071_by, inventory, keyRingItem);
            }
            case 50: {
                ItemStack pouchStack = player.func_184614_ca();
                if (!(pouchStack != null && pouchStack.func_77973_b() instanceof PouchItem || (pouchStack = player.func_184592_cb()) != null && pouchStack.func_77973_b() instanceof PouchItem)) {
                    return null;
                }
                PouchInventory pouchInventory = new PouchInventory(pouchStack);
                return new PouchGui(player.field_71071_by, pouchInventory, pouchStack);
            }
            case 51: {
                return new JewelerBenchGui(player.field_71071_by, world);
            }
            case 52: {
                Treasure.LOGGER.debug("creating charming bench container client-side");
                try {
                    return new CharmingTableGui(player.field_71071_by, world);
                }
                catch (Exception e) {
                    Treasure.LOGGER.error("charming bench error:", (Throwable)e);
                }
            }
        }
        return null;
    }

    private ITreasureChestTileEntity getChestTileEntity(TileEntity tileEntity) {
        ITreasureChestTileEntity chestTileEntity;
        ITreasureChestTileEntity iTreasureChestTileEntity = chestTileEntity = tileEntity instanceof ITreasureChestTileEntity ? (ITreasureChestTileEntity)tileEntity : null;
        if (chestTileEntity == null) {
            Treasure.LOGGER.warn("Umm, GUI handler error - wrong tile entity.");
            return null;
        }
        return chestTileEntity;
    }
}

