/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm.cost;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.cost.CostEvaluator;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import com.someguyssoftware.treasure2.item.Adornment;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EquipmentCostEvaluator
extends CostEvaluator {
    private ICostEvaluator evaluator;

    public EquipmentCostEvaluator() {
        this.evaluator = new CostEvaluator();
    }

    public EquipmentCostEvaluator(ICostEvaluator evaluator) {
        Treasure.LOGGER.debug("receiving child evaluator of -> {}", (Object)evaluator.getClass().getSimpleName());
        this.evaluator = evaluator;
    }

    @Override
    public double apply(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity, double amount) {
        Treasure.LOGGER.debug("executing...");
        double newAmount = amount * 2.0;
        boolean isDamaged = true;
        ArrayList list = new ArrayList();
        AtomicReference itemHolder = new AtomicReference();
        player.func_184209_aF().iterator().forEachRemaining(itemStack -> {
            if (itemStack.func_77984_f() && !(itemStack.func_77973_b() instanceof Adornment)) {
                list.add(itemStack);
            }
        });
        if (!list.isEmpty()) {
            ItemStack selectedStack = (ItemStack)list.get(random.nextInt(list.size()));
            Treasure.LOGGER.debug("selected equip -> {}", (Object)selectedStack.func_82833_r());
            Treasure.LOGGER.debug("going to apply damage -> {} to equip current damage -> {}", (Object)newAmount, (Object)selectedStack.func_77952_i());
            int oldDamage = selectedStack.func_77952_i();
            selectedStack.func_96631_a(Math.toIntExact((long)newAmount), random, null);
            if (selectedStack.func_77952_i() > oldDamage) {
                isDamaged = true;
            }
            Treasure.LOGGER.debug("damaged -> {}, equip damaged after -> {}", (Object)isDamaged, (Object)selectedStack.func_77952_i());
        }
        if (!isDamaged) {
            Treasure.LOGGER.debug("no damage done, use mana using cost eval ->{}", (Object)this.evaluator.getClass().getSimpleName());
            newAmount = entity.getCharm().getCostEvaluator().apply(world, random, coords, player, event, entity, amount);
        }
        return newAmount;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        try {
            super.save(nbt);
            NBTTagCompound tag = new NBTTagCompound();
            this.evaluator.save(tag);
            nbt.func_74782_a("evaluator", (NBTBase)tag);
        }
        catch (Exception e) {
            Treasure.LOGGER.error("error saving EquipmentCostEvaluator -> ", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        try {
            super.load(nbt);
            if (nbt.func_74764_b("evaluator") && nbt.func_74775_l("evaluator").func_74764_b("costClass")) {
                try {
                    NBTTagCompound tag = nbt.func_74775_l("evaluator");
                    String costEvalClass = nbt.func_74779_i("costClass");
                    Object o = Class.forName(costEvalClass).newInstance();
                    ((ICostEvaluator)o).load(tag);
                    this.evaluator = (ICostEvaluator)o;
                }
                catch (Exception e) {
                    Treasure.LOGGER.warn("unable to create cost evaluator from class string:");
                    Treasure.LOGGER.error((Object)e);
                    this.evaluator = new CostEvaluator();
                }
            } else {
                this.evaluator = new CostEvaluator();
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("error loading EquipmentCostEvaluator -> ", (Throwable)e);
        }
    }

    public ICostEvaluator getEvaluator() {
        return this.evaluator;
    }
}

