/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;

public class TreasureCharmRegistry {
    private static final Map<ResourceLocation, ICharm> REGISTRY = new HashMap<ResourceLocation, ICharm>();
    private static final Map<Integer, List<ICharm>> REGISTRY_BY_LEVEL = new HashMap<Integer, List<ICharm>>();
    private static final Map<Rarity, List<ICharm>> REGISTRY_BY_RARITY = new HashMap<Rarity, List<ICharm>>();

    public static void register(ICharm charm) {
        ArrayList<ICharm> charmList;
        if (!REGISTRY.containsKey(charm.getName())) {
            REGISTRY.put(charm.getName(), charm);
        }
        if (!REGISTRY_BY_LEVEL.containsKey(charm.getLevel())) {
            charmList = new ArrayList<ICharm>();
            charmList.add(charm);
            REGISTRY_BY_LEVEL.put(charm.getLevel(), charmList);
        } else {
            REGISTRY_BY_LEVEL.get(charm.getLevel()).add(charm);
        }
        if (!REGISTRY_BY_RARITY.containsKey((Object)charm.getRarity())) {
            charmList = new ArrayList();
            charmList.add(charm);
            REGISTRY_BY_RARITY.put(charm.getRarity(), charmList);
        } else {
            REGISTRY_BY_RARITY.get((Object)charm.getRarity()).add(charm);
        }
    }

    public static Optional<ICharm> get(ResourceLocation name) {
        if (REGISTRY.containsKey(name)) {
            return Optional.of(REGISTRY.get(name));
        }
        return Optional.empty();
    }

    public static Optional<List<ICharm>> get(Integer level) {
        if (REGISTRY_BY_LEVEL.containsKey(level)) {
            return Optional.of(REGISTRY_BY_LEVEL.get(level));
        }
        return Optional.empty();
    }

    public static Optional<List<ICharm>> get(Rarity rarity) {
        if (REGISTRY_BY_RARITY.containsKey((Object)rarity)) {
            return Optional.of(REGISTRY_BY_RARITY.get((Object)rarity));
        }
        return Optional.empty();
    }

    public static Optional<List<ICharm>> getBy(Predicate<ICharm> predicate) {
        ArrayList<ICharm> charms = new ArrayList<ICharm>();
        for (ICharm c : TreasureCharmRegistry.values()) {
            if (!predicate.test(c)) continue;
            charms.add(c);
        }
        if (charms.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(charms);
    }

    public static List<ICharm> values() {
        return new ArrayList<ICharm>(REGISTRY.values());
    }
}

