/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.ICooldownCharmEntity;
import com.someguyssoftware.treasure2.charm.ShieldingCharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ShieldingCharm
extends Charm {
    public static String SHIELDING_TYPE = "shielding";
    private static final Class<?> REGISTERED_EVENT = LivingDamageEvent.class;

    ShieldingCharm(Builder builder) {
        super(builder);
    }

    protected ShieldingCharm(Charm.Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public ICharmEntity createEntity() {
        ShieldingCharmEntity entity = new ShieldingCharmEntity(this);
        return entity;
    }

    @Override
    public ICharmEntity createEntity(ICharmEntity entity) {
        ShieldingCharmEntity newEntity = new ShieldingCharmEntity((ShieldingCharmEntity)entity);
        return newEntity;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (entity instanceof ShieldingCharmEntity) {
            double amount;
            ICooldownCharmEntity charmEntity = (ICooldownCharmEntity)((Object)entity);
            if ((entity.getCooldown() <= 0.0 || (double)world.func_82737_E() > charmEntity.getCooldownEnd()) && entity.getMana() > 0.0 && !player.field_70128_L && ((LivingDamageEvent)event).getEntity() instanceof EntityPlayer && (amount = (double)((LivingDamageEvent)event).getAmount()) > 0.0) {
                double amountToPlayer;
                double amountToCharm = amount * entity.getAmount();
                double newAmount = amountToPlayer = amount - amountToCharm;
                double cost = this.applyCost(world, random, coords, player, event, entity, amountToCharm);
                if (cost < amountToCharm) {
                    newAmount = amountToCharm - cost;
                }
                ((LivingDamageEvent)event).setAmount((float)newAmount);
                if (entity.getCooldown() > 0.0) {
                    ((ICooldownCharmEntity)((Object)entity)).setCooldownEnd(Long.valueOf(world.func_82737_E()).doubleValue() + entity.getCooldown());
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.shielding", (Object[])new Object[]{Math.round(entity.getAmount() * 100.0), (int)(entity.getCooldown() / 20.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(SHIELDING_TYPE, level)), SHIELDING_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new ShieldingCharm(this);
        }
    }
}

