/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SatietyCharm
extends Charm {
    public static final int MAX_FOOD_LEVEL = 20;
    public static final String SATIETY_TYPE = "satiety";
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    SatietyCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if ((double)world.func_82737_E() % this.getFrequency() == 0.0 && !player.field_70128_L && entity.getMana() > 0.0 && player.func_71024_bL().func_75116_a() < 20) {
            player.func_71024_bL().func_75122_a((int)this.getAmount(), (float)((int)this.getAmount()));
            this.applyCost(world, random, coords, player, event, entity, 1.0);
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.satiety", (Object[])new Object[]{(int)(entity.getFrequency() / 20.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(SatietyCharm.SATIETY_TYPE, level)), SatietyCharm.SATIETY_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new SatietyCharm(this);
        }
    }
}

