/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.google.common.collect.FluentIterable;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RuinCurse
extends Charm {
    public static final String RUIN_TYPE = "ruin";
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    RuinCurse(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean isCurse() {
        return true;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (!player.field_70128_L && entity.getMana() > 0.0 && (double)player.func_110143_aJ() > 0.0 && (double)world.func_82737_E() % entity.getFrequency() == 0.0) {
            FluentIterable inventoryEquipment = (FluentIterable)player.func_184209_aF();
            ArrayList actualEquipment = new ArrayList(5);
            inventoryEquipment.forEach(itemStack -> {
                if (itemStack.func_77973_b() != Items.field_190931_a) {
                    actualEquipment.add(itemStack);
                }
            });
            if (actualEquipment != null && actualEquipment.size() > 0) {
                ItemStack selectedItemStack = (ItemStack)actualEquipment.get(random.nextInt(actualEquipment.size()));
                Treasure.LOGGER.debug("damaging item -> {}, current damage -> {} of {}", (Object)selectedItemStack.func_82833_r(), (Object)selectedItemStack.func_77952_i(), (Object)selectedItemStack.func_77958_k());
                if (selectedItemStack.func_77984_f()) {
                    selectedItemStack.func_96631_a((int)this.getAmount(), random, null);
                    Treasure.LOGGER.debug("damaged item -> {}, now at damaged -> {} of {}", (Object)selectedItemStack.func_82833_r(), (Object)selectedItemStack.func_77952_i(), (Object)selectedItemStack.func_77958_k());
                    this.applyCost(world, random, coords, player, event, entity, this.getAmount());
                }
            }
            Treasure.LOGGER.debug("charm {} new data -> {}", (Object)this.getName(), (Object)entity);
            result = true;
        }
        return result;
    }

    @Override
    public TextFormatting getCharmLabelColor() {
        return TextFormatting.DARK_RED;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.ruin", (Object[])new Object[]{DECIMAL_FORMAT.format(this.getAmount() / 2.0), DECIMAL_FORMAT.format(entity.getFrequency() / 20.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(RuinCurse.RUIN_TYPE, level)), RuinCurse.RUIN_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new RuinCurse(this);
        }
    }
}

