/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.CharmEntity;
import com.someguyssoftware.treasure2.charm.LifeStrikeCharm;
import net.minecraft.nbt.NBTTagCompound;

public class LifeStrikeCharmEntity
extends CharmEntity {
    private double lifeCost;

    public LifeStrikeCharmEntity() {
    }

    public LifeStrikeCharmEntity(LifeStrikeCharm charm) {
        super(charm);
        this.setLifeCost(charm.getLifeCost());
    }

    public LifeStrikeCharmEntity(LifeStrikeCharmEntity entity) {
        super(entity);
        this.setLifeCost(entity.getLifeCost());
    }

    @Override
    public boolean load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("lifeCost")) {
            this.setLifeCost(nbt.func_74769_h("lifeCost"));
        }
        return true;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt = super.save(nbt);
        try {
            nbt.func_74780_a("lifeCost", this.getLifeCost());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    public double getLifeCost() {
        return this.lifeCost;
    }

    public void setLifeCost(double lifeCost) {
        this.lifeCost = lifeCost;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lifeCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LifeStrikeCharmEntity other = (LifeStrikeCharmEntity)obj;
        return Double.doubleToLongBits(this.lifeCost) == Double.doubleToLongBits(other.lifeCost);
    }

    @Override
    public String toString() {
        return "LifeStrikeCharmEntity [lifeCost=" + this.lifeCost + "]";
    }
}

