/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.LifeStrikeCharmEntity;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LifeStrikeCharm
extends Charm {
    private static final float LIFE_AMOUNT = 2.0f;
    public static String LIFE_STRIKE_TYPE = "life_strike";
    private static final Class<?> REGISTERED_EVENT = LivingHurtEvent.class;
    private double lifeCost;

    LifeStrikeCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public ICharmEntity createEntity() {
        LifeStrikeCharmEntity entity = new LifeStrikeCharmEntity(this);
        return entity;
    }

    @Override
    public ICharmEntity createEntity(ICharmEntity entity) {
        LifeStrikeCharmEntity newEntity = new LifeStrikeCharmEntity((LifeStrikeCharmEntity)entity);
        return newEntity;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        DamageSource source;
        boolean result = false;
        if (entity.getMana() > 0.0 && !player.field_70128_L && (source = ((LivingHurtEvent)event).getSource()).func_76346_g() instanceof EntityPlayer && player.func_110143_aJ() > 5.0f) {
            double sourceAmount = ((LivingHurtEvent)event).getAmount();
            double lifeStrikeAmount = sourceAmount + sourceAmount * entity.getAmount();
            ((LivingHurtEvent)event).setAmount((float)lifeStrikeAmount);
            this.applyCost(world, random, coords, player, event, entity, Math.max(1.0, Math.min(5.0, lifeStrikeAmount - sourceAmount)));
            result = true;
            Treasure.LOGGER.debug("life strike damage {} onto mob -> {} using damage type -> {}", (Object)(sourceAmount * entity.getAmount()), (Object)source.func_76346_g().func_70005_c_(), (Object)source.func_76355_l());
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.life_strike", (Object[])new Object[]{Math.round(entity.getAmount() * 100.0)});
    }

    public double getLifeCost() {
        return this.lifeCost;
    }

    public void setLifeCost(double lifeCost) {
        this.lifeCost = lifeCost;
    }

    public static class CostEvaluator
    implements ICostEvaluator {
        @Override
        public double apply(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity, double amount) {
            double cost = amount;
            LifeStrikeCharmEntity lifeEntity = (LifeStrikeCharmEntity)entity;
            if (entity instanceof LifeStrikeCharmEntity) {
                player.func_70606_j(MathHelper.func_76131_a((float)(player.func_110143_aJ() - (float)lifeEntity.getLifeCost()), (float)0.0f, (float)player.func_110138_aP()));
                if (entity.getMana() < amount) {
                    cost = entity.getMana();
                }
                double remaining = entity.getMana() - cost;
                entity.setMana(MathHelper.func_151237_a((double)remaining, (double)0.0, (double)entity.getMana()));
            }
            return cost;
        }
    }

    public static class Builder
    extends Charm.Builder {
        public double lifeCost = 2.0;

        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(LIFE_STRIKE_TYPE, level)), LIFE_STRIKE_TYPE, level);
        }

        public Builder withLifeCost(double lifeCost) {
            this.lifeCost = lifeCost;
            return this;
        }

        @Override
        public ICharm build() {
            return new LifeStrikeCharm(this);
        }
    }
}

